<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login - Server Panel</title>
    <link href="https://fonts.googleapis.com/css2?family=Outfit:wght@300;400;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root {
            --primary: #22d3ee;
            --secondary: #6366f1;
            --bg-dark: #020617;
            --bg-card: rgba(15,23,42,0.92);
            --text-main: #e5f2ff;
            --border: rgba(148,163,184,0.28);
            --accent: #4ade80;
        }

        * { box-sizing:border-box; margin:0; padding:0; }

        body {
            min-height: 100vh;
            margin: 0;
            font-family: 'Outfit', sans-serif;
            color: var(--text-main);
            background:
                radial-gradient(circle at 0% 0%, rgba(34,197,94,0.25), transparent 55%),
                radial-gradient(circle at 100% 100%, rgba(56,189,248,0.25), transparent 55%),
                #020617;
            display: flex;
            align-items: center;
            justify-content: center;
            overflow: hidden;
            position: relative;
        }

        /* floating glow orbs */
        .orb {
            position:absolute;
            width:220px;height:220px;
            border-radius:50%;
            filter: blur(40px);
            opacity:0.5;
            mix-blend-mode:screen;
            pointer-events:none;
            animation: float 14s ease-in-out infinite alternate;
        }
        .orb.orb-1 { background:#22c55e; top:-60px; left:-40px; }
        .orb.orb-2 { background:#0ea5e9; bottom:-80px; right:-60px; animation-delay: -6s; }
        @keyframes float {
            0%   { transform:translate3d(0,0,0) scale(1); }
            100% { transform:translate3d(40px,30px,0) scale(1.08); }
        }

        .login-shell {
            width: 100%;
            max-width: 960px;
            display: grid;
            grid-template-columns: minmax(0,1.05fr) minmax(0,0.95fr);
            gap: 0;
            border-radius: 26px;
            border: 1px solid rgba(148,163,184,0.35);
            background: radial-gradient(circle at 0 0, rgba(34,197,94,0.12), transparent 65%),
                        radial-gradient(circle at 100% 100%, rgba(56,189,248,0.12), transparent 55%),
                        linear-gradient(135deg, rgba(15,23,42,0.96), rgba(15,23,42,0.92));
            box-shadow: 0 30px 80px rgba(0,0,0,0.9);
            position: relative;
            overflow: hidden;
        }

        .login-hero {
            padding: 30px 32px;
            border-right: 1px solid rgba(15,23,42,0.85);
            position: relative;
        }
        .login-hero-header {
            display:flex;
            align-items:center;
            gap:10px;
            margin-bottom:18px;
        }
        .login-logo-icon {
            width:40px;height:40px;
            border-radius:14px;
            background:conic-gradient(from 210deg,#22d3ee,#4ade80,#6366f1,#22d3ee);
            display:flex;align-items:center;justify-content:center;
            color:#0b1120;
            box-shadow:0 0 0 1px rgba(15,23,42,0.9),0 16px 40px rgba(34,197,94,0.55);
        }
        .login-brand {
            font-size:1.15rem;
            font-weight:800;
            letter-spacing:.04em;
        }
        .login-brand span {
            display:block;
            font-size:.7rem;
            font-weight:500;
            color:#64748b;
            text-transform:uppercase;
            letter-spacing:.18em;
        }

        .login-hero-title {
            font-size:1.4rem;
            font-weight:700;
            margin-bottom:8px;
        }
        .login-hero-sub {
            font-size:.9rem;
            color:#9ca3af;
            margin-bottom:24px;
        }

        .login-metrics {
            display:flex;
            gap:10px;
            flex-wrap:wrap;
            margin-bottom:24px;
        }
        .metric-card {
            flex:1;
            min-width:140px;
            background:rgba(15,23,42,0.92);
            border-radius:14px;
            border:1px solid rgba(75,85,99,0.7);
            padding:10px 12px;
            position:relative;
            overflow:hidden;
        }
        .metric-label {
            font-size:.7rem;
            color:#9ca3af;
            text-transform:uppercase;
            letter-spacing:.12em;
            margin-bottom:4px;
        }
        .metric-value {
            font-size:1.05rem;
            font-weight:700;
        }
        .metric-pill {
            font-size:.7rem;
            padding:3px 9px;
            border-radius:999px;
            background:rgba(34,197,94,0.16);
            color:#bbf7d0;
            margin-top:6px;
            display:inline-flex;
            align-items:center;
            gap:4px;
        }

        .heartbeat-mini {
            position:absolute;
            right:-6px;
            bottom:-4px;
            width:90px;
            height:36px;
            opacity:.45;
        }
        .heartbeat-mini svg {
            width:100%;height:100%;
        }
        .heartbeat-mini polyline {
            stroke:#4ade80;
            stroke-width:2;
            fill:none;
            stroke-linejoin:round;
            stroke-linecap:round;
            stroke-dasharray:120;
            stroke-dashoffset:120;
            animation: hbMini 2.2s linear infinite;
            filter:drop-shadow(0 0 4px rgba(34,197,94,0.6));
        }
        @keyframes hbMini {
            0%{stroke-dashoffset:120;opacity:.2;}
            15%{opacity:1;}
            100%{stroke-dashoffset:0;opacity:.9;}
        }

        .login-footer-note {
            font-size:.74rem;
            color:#6b7280;
        }

        .login-form-wrap {
            padding:30px 30px 30px 26px;
            background:radial-gradient(circle at 100% 0,rgba(14,165,233,0.18),transparent 60%);
        }

        .login-heading {
            font-size:1.1rem;
            font-weight:700;
            margin-bottom:6px;
        }
        .login-subheading {
            font-size:.8rem;
            color:#94a3b8;
            margin-bottom:18px;
        }

        .form-group {
            margin-bottom: 1.3rem;
        }
        label {
            display: block;
            margin-bottom: 0.4rem;
            font-size: 0.82rem;
            color: #a5b4fc;
        }
        .field {
            position:relative;
        }
        .field input {
            width: 100%;
            padding: 0.7rem 2.4rem 0.7rem 0.9rem;
            background: rgba(15, 23, 42, 0.9);
            border: 1px solid rgba(51,65,85,0.9);
            border-radius: 12px;
            color: #e5e7eb;
            font-family: inherit;
            font-size:.85rem;
            outline:none;
            transition:border-color .18s, box-shadow .18s, background .18s;
        }
        .field input:focus {
            border-color: var(--primary);
            box-shadow: 0 0 0 1px rgba(34,211,238,0.7);
            background: rgba(15,23,42,1);
        }
        .field-icon {
            position:absolute;
            right:10px;
            top:50%;
            transform:translateY(-50%);
            color:#4b5563;
            font-size:.9rem;
        }
        .toggle-pass {
            position:absolute;
            right:10px;
            top:50%;
            transform:translateY(-50%);
            background:none;
            border:none;
            color:#64748b;
            font-size:.75rem;
            cursor:pointer;
        }

        .login-btn {
            width: 100%;
            padding: 0.8rem;
            background: linear-gradient(135deg, var(--primary), var(--secondary));
            border: none;
            border-radius: 14px;
            color: #0b1120;
            font-weight: 700;
            cursor: pointer;
            transition: transform 0.18s ease, box-shadow 0.18s ease;
            font-size:.9rem;
            display:inline-flex;
            align-items:center;
            justify-content:center;
            gap:6px;
            box-shadow:0 18px 40px rgba(56,189,248,0.4);
        }
        .login-btn:hover {
            transform: translateY(-2px);
            box-shadow:0 20px 50px rgba(56,189,248,0.55);
        }

        .error {
            color: #f97373;
            font-size: 0.78rem;
            margin-top: 0.35rem;
        }

        .login-meta {
            margin-top: 16px;
            font-size:.75rem;
            color:#94a3b8;
            display:flex;
            justify-content:space-between;
            align-items:center;
            gap:8px;
            flex-wrap:wrap;
        }
        .badge-env {
            padding:4px 9px;
            border-radius:999px;
            border:1px solid rgba(148,163,184,0.6);
            font-size:.68rem;
            text-transform:uppercase;
            letter-spacing:.16em;
            color:#e5e7eb;
        }

        @media (max-width: 820px) {
            .login-shell {
                grid-template-columns: minmax(0,1fr);
            }
            .login-hero {
                display:none;
            }
            .login-form-wrap {
                padding:26px 22px 24px;
            }
        }

        /* ── Success preloader overlay ── */
        .login-preloader {
            position:fixed;
            inset:0;
            background:radial-gradient(circle at 10% 0,rgba(34,197,94,0.3),transparent 55%),rgba(2,6,23,0.96);
            display:flex;
            flex-direction:column;
            align-items:center;
            justify-content:center;
            z-index:999;
            opacity:0;
            pointer-events:none;
            transition:opacity .25s ease;
        }
        .login-preloader.show {
            opacity:1;
            pointer-events:auto;
        }
        .lp-ring {
            width:78px;height:78px;
            border-radius:50%;
            border:3px solid rgba(15,23,42,1);
            border-top-color:#22d3ee;
            border-right-color:#4ade80;
            animation: lpSpin 0.9s linear infinite;
            box-shadow:0 0 0 1px rgba(15,23,42,0.9),0 0 35px rgba(34,197,94,0.55);
            display:flex;align-items:center;justify-content:center;
            position:relative;
        }
        .lp-ring::after {
            content:'';
            width:40px;height:40px;
            border-radius:50%;
            border:2px dashed rgba(148,163,184,0.6);
            animation: lpSpin 2.4s linear infinite reverse;
        }
        .lp-icon {
            position:absolute;
            font-size:1.1rem;
            color:#e5f2ff;
        }
        @keyframes lpSpin {
            to { transform:rotate(360deg); }
        }
        .lp-title {
            margin-top:18px;
            font-size:1.0rem;
            font-weight:700;
        }
        .lp-sub {
            margin-top:4px;
            font-size:.8rem;
            color:#9ca3af;
        }
    </style>
</head>

<body>
    <div class="orb orb-1"></div>
    <div class="orb orb-2"></div>

    <div class="login-preloader" id="loginPreloader">
        <div class="lp-ring">
            <i class="fas fa-server lp-icon"></i>
        </div>
        <div class="lp-title">Logging you in…</div>
        <div class="lp-sub">Securing session &amp; loading Koro Panel</div>
    </div>

    <div class="login-shell">
        <div class="login-hero">
            <div class="login-hero-header">
                <div class="login-logo-icon"><i class="fas fa-bolt"></i></div>
                <div class="login-brand">
                    Server Hosting
                    <span>Cloud Hosting Console</span>
                </div>
            </div>
            <div class="login-hero-title">Fast, secure server control.</div>
            <div class="login-hero-sub">Login to manage domains, databases, emails and more from a single, beautiful dashboard.</div>

            <div class="login-metrics">
                <div class="metric-card">
                    <div class="metric-label">Live Uptime</div>
                    <div class="metric-value">99.9%</div>
                    <span class="metric-pill"><i class="fas fa-arrow-up"></i> Stable</span>
                    <div class="heartbeat-mini">
                        <svg viewBox="0 0 90 36">
                            <polyline points="0,22 10,22 16,16 22,26 30,10 38,26 48,20 58,22 68,14 76,26 86,22" />
                        </svg>
                    </div>
                </div>
                <div class="metric-card">
                    <div class="metric-label">Active Servers</div>
                    <div class="metric-value">24</div>
                    <span class="metric-pill" style="background:rgba(56,189,248,0.16);color:#bae6fd;">
                        <i class="fas fa-server"></i> Online
                    </span>
                </div>
            </div>

            <div class="login-footer-note">
                Tip: Use the master admin credentials provided by your hosting provider to access all client panels.
            </div>
        </div>

        <div class="login-form-wrap">
            <div class="login-heading">Sign in to Server Panel</div>
            <div class="login-subheading">Enter your credentials to access your hosting dashboard.</div>

            <form method="POST" action="<?php echo e(route('login')); ?>" id="loginForm">
                <?php echo csrf_field(); ?>
                <div class="form-group">
                    <label>Email Address</label>
                    <div class="field">
                        <input type="email" name="email" required placeholder="you@example.com" value="<?php echo e(old('email')); ?>">
                        <span class="field-icon"><i class="fas fa-envelope"></i></span>
                    </div>
                    <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="error"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
                <div class="form-group">
                    <label>Password</label>
                    <div class="field">
                        <input type="password" name="password" id="loginPassword" required placeholder="••••••••">
                        <button type="button" class="toggle-pass" onclick="togglePass()">Show</button>
                    </div>
                </div>
                <button type="submit" class="login-btn">
                    <i class="fas fa-sign-in-alt"></i> Sign In
                </button>
            </form>

            
        </div>
    </div>

    <script>
        function togglePass() {
            var inp = document.getElementById('loginPassword');
            var btn = event.currentTarget;
            if (inp.type === 'password') {
                inp.type = 'text';
                btn.textContent = 'Hide';
            } else {
                inp.type = 'password';
                btn.textContent = 'Show';
            }
        }

        // Show preloader on submit
        (function() {
            var form = document.getElementById('loginForm');
            var pre  = document.getElementById('loginPreloader');
            if (!form || !pre) return;

            form.addEventListener('submit', function() {
                // prevent double submit
                if (form.dataset.submitted === '1') return;
                form.dataset.submitted = '1';

                var btn = form.querySelector('.login-btn');
                if (btn) {
                    btn.disabled = true;
                    btn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Signing in…';
                }
                pre.classList.add('show');
            });
        })();
    </script>
</body>

</html><?php /**PATH C:\Program Files\Ampps\www\resources\views/auth/login.blade.php ENDPATH**/ ?>