

<?php $__env->startSection('styles'); ?>
    <style>
        .picker-grid {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(280px, 1fr));
            gap: 1.5rem;
            margin-top: 2rem;
        }

        .picker-card {
            background: var(--bg-card);
            border: 1px solid var(--border);
            border-radius: 20px;
            padding: 2rem;
            text-decoration: none;
            color: inherit;
            transition: all 0.3s;
            display: flex;
            align-items: center;
            gap: 1.5rem;
        }

        .picker-card:hover {
            transform: translateY(-5px);
            border-color: var(--primary);
            box-shadow: 0 10px 30px -10px rgba(99, 102, 241, 0.3);
        }

        .picker-icon {
            width: 60px;
            height: 60px;
            background: rgba(99, 102, 241, 0.1);
            border-radius: 15px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.5rem;
            color: var(--primary);
            flex-shrink: 0;
        }

        .picker-info h3 {
            font-size: 1.1rem;
            margin-bottom: 0.3rem;
        }

        .picker-info p {
            color: var(--text-muted);
            font-size: 0.85rem;
        }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="animate-fade">
        <h2 style="margin-bottom: 0.5rem;">File Manager</h2>
        <p style="color: var(--text-muted); margin-bottom: 2rem;">Select a domain to manage its files</p>

        <?php if(session('error')): ?>
            <div
                style="background: rgba(239, 68, 68, 0.1); color: #ef4444; padding: 1rem; border-radius: 12px; margin-bottom: 1.5rem; border: 1px solid rgba(239, 68, 68, 0.3);">
                <?php echo e(session('error')); ?>

            </div>
        <?php endif; ?>

        <div class="picker-grid">
            <?php $__empty_1 = true; $__currentLoopData = $userDomains; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ud): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <a href="<?php echo e(route('files', ['domain' => $ud->domain, 'root' => 'domains/' . $ud->domain])); ?>"
                    class="picker-card">
                    <div class="picker-icon"><i class="fas fa-globe"></i></div>
                    <div class="picker-info">
                        <h3><?php echo e($ud->domain); ?></h3>
                        <p>~/domains/<?php echo e($ud->domain); ?></p>
                    </div>
                </a>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <div
                    style="grid-column: 1 / -1; text-align: center; padding: 4rem; background: var(--bg-card); border-radius: 24px; border: 1px dashed var(--border);">
                    <i class="fas fa-folder-open" style="font-size: 3rem; color: var(--text-muted); margin-bottom: 1rem;"></i>
                    <p style="color: var(--text-muted); margin-bottom: 1rem;">You haven't created any domains yet.</p>
                    <a href="<?php echo e(route('domains')); ?>" class="btn-primary"><i class="fas fa-plus"></i> Create Domain</a>
                </div>
            <?php endif; ?>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.dashboard', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Program Files\Ampps\www\resources\views/dashboard/file_picker.blade.php ENDPATH**/ ?>