<?php $__env->startSection('styles'); ?>
<style>
/* ── Dashboard Hero ── */
.db-hero {
    background: linear-gradient(135deg, #161b22 0%, #1e1b4b 60%, #0d1117 100%);
    border: 1px solid rgba(99,102,241,.25);
    border-radius: 20px;
    padding: 28px 32px;
    margin-bottom: 24px;
    position: relative;
    overflow: hidden;
}
.db-hero::after {
    content: '';
    position: absolute;
    top: -60px; right: -80px;
    width: 320px; height: 320px;
    background: radial-gradient(circle, rgba(99,102,241,.18) 0%, transparent 70%);
    pointer-events: none;
}

/* ── Subtle green heartbeat graph in hero bg ── */
.db-heartbeat-wrap {
    position: absolute;
    right: 20px;
    bottom: 18px;
    width: 180px;
    height: 42px;
    overflow: hidden;
    opacity: 0.32;
    pointer-events: none;
}
.db-heartbeat-grid {
    position:absolute;
    inset:0;
    background: linear-gradient(to right, rgba(34,197,94,0.12) 1px, transparent 1px),
                linear-gradient(to top, rgba(34,197,94,0.12) 1px, transparent 1px);
    background-size: 12px 10px;
}
.db-heartbeat-line {
    position:absolute;
    inset:0;
    stroke: #4ade80;
    fill: none;
    stroke-width: 2;
    stroke-linejoin: round;
    stroke-linecap: round;
    filter: drop-shadow(0 0 6px rgba(34,197,94,0.4));
    stroke-dasharray: 220;
    stroke-dashoffset: 220;
    animation: dbHeartbeat 2.4s linear infinite;
}
@keyframes dbHeartbeat {
    0%   { stroke-dashoffset: 220; opacity: 0.1; }
    10%  { opacity: 1; }
    100% { stroke-dashoffset: 0; opacity: 0.9; }
}
.db-hero-greeting {
    font-size: 1.5rem;
    font-weight: 800;
    color: #e6edf3;
    margin-bottom: 6px;
    position: relative; z-index: 1;
}
.db-hero-sub {
    font-size: .82rem;
    color: #8b949e;
    position: relative; z-index: 1;
}

/* ── Stats Row ── */
.db-stats {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
    gap: 14px;
    margin-bottom: 24px;
}
.db-stat {
    background: #161b22;
    border: 1px solid #21262d;
    border-radius: 16px;
    padding: 18px 20px;
    transition: all .2s;
    position: relative;
    overflow: hidden;
}
.db-stat:hover {
    border-color: #30363d;
    transform: translateY(-2px);
    box-shadow: 0 8px 24px rgba(0,0,0,.25);
}
.db-stat-icon {
    width: 38px; height: 38px;
    border-radius: 10px;
    display: flex; align-items: center; justify-content: center;
    font-size: .95rem;
    margin-bottom: 10px;
}
.db-stat-val {
    font-size: 1.35rem;
    font-weight: 800;
    color: #e6edf3;
    line-height: 1.1;
}
.db-stat-label {
    font-size: .68rem;
    color: #8b949e;
    text-transform: uppercase;
    letter-spacing: .06em;
    margin-top: 4px;
}
.db-stat-bar {
    height: 4px;
    background: rgba(255,255,255,.06);
    border-radius: 4px;
    margin-top: 12px;
    overflow: hidden;
}
.db-stat-bar-fill { height: 100%; border-radius: 4px; transition: width 1s ease; }

/* ── Plan Card ── */
.db-plan {
    background: #161b22;
    border: 1px solid #21262d;
    border-radius: 20px;
    overflow: hidden;
    margin-bottom: 24px;
}
.db-plan-head {
    display: flex;
    align-items: center;
    justify-content: space-between;
    padding: 18px 22px;
    background: linear-gradient(90deg, rgba(99,102,241,.1), transparent);
    border-bottom: 1px solid #21262d;
    flex-wrap: wrap;
    gap: 10px;
}
.db-plan-name {
    display: flex; align-items: center; gap: 10px;
}
.db-plan-name-icon {
    width: 36px; height: 36px;
    border-radius: 10px;
    background: rgba(99,102,241,.2);
    color: #a5b4fc;
    display: flex; align-items: center; justify-content: center;
    font-size: .9rem;
}
.db-plan-name h3 {
    font-size: .95rem;
    font-weight: 800;
    color: #e6edf3;
    margin: 0;
}
.db-plan-name span {
    font-size: .68rem;
    color: #8b949e;
    display: block;
}
.db-plan-status-badge {
    display: inline-flex; align-items: center; gap: 5px;
    padding: 4px 12px;
    border-radius: 20px;
    font-size: .72rem;
    font-weight: 700;
}
.db-plan-status-badge.active  { background: rgba(34,197,94,.12);  border: 1px solid rgba(34,197,94,.25);  color: #4ade80; }
.db-plan-status-badge.warning { background: rgba(245,158,11,.1);  border: 1px solid rgba(245,158,11,.25); color: #fbbf24; }
.db-plan-status-badge.expired { background: rgba(239,68,68,.1);   border: 1px solid rgba(239,68,68,.25);  color: #f87171; }

.db-plan-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(160px, 1fr));
    gap: 0;
}
.db-plan-item {
    padding: 16px 22px;
    border-right: 1px solid #21262d;
    border-bottom: 1px solid #21262d;
}
.db-plan-item:last-child { border-right: none; }
.db-plan-item-label {
    font-size: .65rem;
    text-transform: uppercase;
    letter-spacing: .07em;
    color: #475569;
    margin-bottom: 6px;
    display: flex; align-items: center; gap: 5px;
}
.db-plan-item-val {
    font-size: .9rem;
    font-weight: 700;
    color: #e6edf3;
    line-height: 1.3;
}
.db-plan-item-val.danger { color: #f87171; }
.db-plan-item-val.warning { color: #fbbf24; }
.db-plan-item-val.green { color: #4ade80; }
.db-plan-item-sub {
    font-size: .65rem;
    color: #8b949e;
    margin-top: 2px;
}

/* ── Nameserver Card ── */
.db-ns {
    background: linear-gradient(135deg, #0d1117, #161b22);
    border: 1px solid rgba(99,102,241,.2);
    border-radius: 16px;
    padding: 20px 22px;
    margin-bottom: 24px;
}
.db-ns-head {
    display: flex; align-items: center; gap: 10px;
    margin-bottom: 16px;
}
.db-ns-head-icon {
    width: 34px; height: 34px;
    border-radius: 10px;
    background: rgba(99,102,241,.15);
    color: #a5b4fc;
    display: flex; align-items: center; justify-content: center;
    font-size: .82rem;
}
.db-ns-head h4 { font-size: .88rem; font-weight: 700; color: #e6edf3; margin: 0; }
.db-ns-head span { font-size: .7rem; color: #8b949e; display: block; margin-top: 1px; }
.db-ns-grid { display: grid; grid-template-columns: 1fr 1fr; gap: 10px; }
@media(max-width:500px){ .db-ns-grid { grid-template-columns: 1fr; } }
.db-ns-item {
    background: #0d1117;
    border: 1px solid #21262d;
    border-radius: 10px;
    padding: 10px 14px;
    display: flex; align-items: center; gap: 10px;
}
.db-ns-num {
    width: 22px; height: 22px;
    border-radius: 6px;
    background: rgba(99,102,241,.15);
    color: #818cf8;
    font-size: .65rem;
    font-weight: 700;
    display: flex; align-items: center; justify-content: center;
    flex-shrink: 0;
}
.db-ns-val {
    font-size: .8rem;
    font-weight: 600;
    color: #c7d2fe;
    font-family: 'Courier New', monospace;
    flex: 1;
}
.db-ns-copy {
    background: none;
    border: none;
    color: #475569;
    cursor: pointer;
    font-size: .75rem;
    padding: 2px 4px;
    border-radius: 4px;
    transition: color .15s;
    flex-shrink: 0;
}
.db-ns-copy:hover { color: #a5b4fc; }

/* responsive */
@media(max-width:700px){
    .db-hero { padding: 20px 18px; }
    .db-hero-greeting { font-size: 1.2rem; }
    .db-plan-grid { grid-template-columns: 1fr 1fr; }
}
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<?php
    $u        = Auth::user();
    $days     = $u->daysUntilExpiry();
    $subStat  = $u->subscriptionStatus();
    $hasExpiry = $u->subscription_expires_at !== null;

    if ($subStat === 'expired')        $badgeClass = 'expired';
    elseif ($days !== null && $days <= 7) $badgeClass = 'warning';
    else                                $badgeClass = 'active';
?>

<div class="animate-fade" style="max-width:960px;margin:0 auto;padding:8px 0 40px;">

    
    <div class="db-hero">
        <div class="db-hero-greeting">👋 Hello, <?php echo e($u->name); ?>!</div>
        <div class="db-hero-sub">Welcome back to <strong>Server Panel</strong>. Here's your hosting overview.</div>

        
        <div class="db-heartbeat-wrap">
            <div class="db-heartbeat-grid"></div>
            <svg viewBox="0 0 180 42">
                <polyline class="db-heartbeat-line"
                          points="0,26 18,26 26,18 34,34 46,10 58,32 74,26 90,26 104,12 116,34 130,18 142,30 158,22 172,26 180,26" />
            </svg>
        </div>
    </div>

    
    <div class="db-stats">
        
        <div class="db-stat">
            <div class="db-stat-icon" style="background:rgba(99,102,241,.12);color:#a5b4fc;">
                <i class="fas fa-globe"></i>
            </div>
            <div class="db-stat-val">
                <?php echo e($usage['domains']['used'] ?? 0); ?>

                <span style="font-size:.7rem;font-weight:500;color:#8b949e;">/ <?php echo e($usage['domains']['limit'] ?? $u->domain_limit); ?></span>
            </div>
            <div class="db-stat-label">Domains Used</div>
            <div class="db-stat-bar">
                <div class="db-stat-bar-fill"
                     style="width:<?php echo e($usage['domains']['percent'] ?? 0); ?>%;background:#6366f1;"></div>
            </div>
        </div>

        
        <?php
            $diskUsed    = $usage['disk']['used']     ?? 0;
            $diskLimit   = $usage['disk']['limit']    ?? $u->disk_quota;
            $diskUnit    = $usage['disk']['unit']     ?? strtoupper($u->disk_quota_unit ?? 'GB');
            $diskPct     = $usage['disk']['percent']  ?? 0;
            $diskColor   = $diskPct >= 90 ? '#ef4444' : ($diskPct >= 70 ? '#f59e0b' : '#10b981');
        ?>
        <div class="db-stat">
            <div class="db-stat-icon" style="background:rgba(16,185,129,.1);color:#10b981;">
                <i class="fas fa-hdd"></i>
            </div>
            <div class="db-stat-val">
                <?php echo e(number_format($diskUsed, 2)); ?> <?php echo e($diskUnit); ?>

                <span style="font-size:.7rem;font-weight:500;color:#8b949e;">
                    / <?php echo e(number_format($diskLimit, 2)); ?> <?php echo e($diskUnit); ?>

                    (<?php echo e($diskPct); ?>%)
                </span>
            </div>
            <div class="db-stat-label">Storage Used</div>
            <div class="db-stat-bar">
                <div class="db-stat-bar-fill" style="width:<?php echo e($diskPct); ?>%;background:<?php echo e($diskColor); ?>;"></div>
            </div>
        </div>

        
        <div class="db-stat">
            <div class="db-stat-icon" style="background:rgba(236,72,153,.1);color:#ec4899;">
                <i class="fas fa-envelope"></i>
            </div>
            <div class="db-stat-val">
                <span style="font-size:.7rem;font-weight:500;color:#8b949e;">Up to</span>
                <?php echo e($u->email_limit ?? '—'); ?>

            </div>
            <div class="db-stat-label">Email Accounts</div>
        </div>
    </div>

    
    <div class="db-plan">
        <div class="db-plan-head">
            <div class="db-plan-name">
                <div class="db-plan-name-icon"><i class="fas fa-box-open"></i></div>
                <div>
                    <h3><?php echo e($u->plan_name ?: 'Basic Plan'); ?></h3>
                    <span>Your current hosting plan</span>
                </div>
            </div>
            <span class="db-plan-status-badge <?php echo e($badgeClass); ?>">
                <?php if($badgeClass === 'active'): ?>
                    <i class="fas fa-circle" style="font-size:.45rem;"></i> Active
                <?php elseif($badgeClass === 'warning'): ?>
                    <i class="fas fa-exclamation-circle"></i> Expiring Soon
                <?php else: ?>
                    <i class="fas fa-times-circle"></i> Expired
                <?php endif; ?>
            </span>
        </div>

        <div class="db-plan-grid">
            
            <div class="db-plan-item">
                <div class="db-plan-item-label"><i class="fas fa-dollar-sign"></i> Plan Price</div>
                <div class="db-plan-item-val green">
                    $<?php echo e(number_format($u->billing_amount ?? 0, 2)); ?>

                </div>
                <div class="db-plan-item-sub">per billing cycle</div>
            </div>

            
            <div class="db-plan-item">
                <div class="db-plan-item-label"><i class="fas fa-calendar-alt"></i> Expiry Date</div>
                <?php if($hasExpiry): ?>
                    <div class="db-plan-item-val <?php echo e($badgeClass === 'expired' ? 'danger' : ($badgeClass === 'warning' ? 'warning' : '')); ?>">
                        <?php echo e($u->subscription_expires_at->format('d M Y')); ?>

                    </div>
                    <div class="db-plan-item-sub">
                        <?php if($subStat === 'expired'): ?>
                            Expired <?php echo e(abs($days)); ?> day<?php echo e(abs($days) != 1 ? 's' : ''); ?> ago
                        <?php else: ?>
                            <?php echo e($days); ?> day<?php echo e($days != 1 ? 's' : ''); ?> remaining
                        <?php endif; ?>
                    </div>
                <?php else: ?>
                    <div class="db-plan-item-val green">Lifetime</div>
                    <div class="db-plan-item-sub">No expiry set</div>
                <?php endif; ?>
            </div>

            
            <div class="db-plan-item">
                <div class="db-plan-item-label"><i class="fas fa-globe"></i> Primary Domain</div>
                <div class="db-plan-item-val" style="font-size:.82rem;font-family:'Courier New',monospace;">
                    <?php echo e($u->primary_domain ?: '—'); ?>

                </div>
                <div class="db-plan-item-sub">main hosting domain</div>
            </div>

            
            <div class="db-plan-item">
                <div class="db-plan-item-label"><i class="fas fa-database"></i> Storage Quota</div>
                <div class="db-plan-item-val">
                    <?php echo e($u->disk_quota); ?> <?php echo e(strtoupper($u->disk_quota_unit ?? 'GB')); ?>

                </div>
                <div class="db-plan-item-sub">total allocated space</div>
            </div>

            
            <div class="db-plan-item">
                <div class="db-plan-item-label"><i class="fas fa-layer-group"></i> Domain Limit</div>
                <div class="db-plan-item-val"><?php echo e($u->domain_limit ?? '—'); ?></div>
                <div class="db-plan-item-sub">addon domains allowed</div>
            </div>

            
            <div class="db-plan-item" style="border-right:none;">
                <div class="db-plan-item-label"><i class="fas fa-envelope"></i> Email Limit</div>
                <div class="db-plan-item-val"><?php echo e($u->email_limit ?? '—'); ?></div>
                <div class="db-plan-item-sub">email accounts allowed</div>
            </div>
        </div>
    </div>

    
    <div class="db-ns">
        <div class="db-ns-head">
            <div class="db-ns-head-icon"><i class="fas fa-server"></i></div>
            <div>
                <h4>Nameservers</h4>
                <span>Point your domain to these nameservers</span>
            </div>
        </div>
        <div class="db-ns-grid">
            <div class="db-ns-item">
                <div class="db-ns-num">NS1</div>
                <div class="db-ns-val" id="ns1val">bdns3.mywhiteserver.com</div>
                <button class="db-ns-copy" onclick="dbCopyNS('ns1val', this)" title="Copy">
                    <i class="fas fa-copy"></i>
                </button>
            </div>
            <div class="db-ns-item">
                <div class="db-ns-num">NS2</div>
                <div class="db-ns-val" id="ns2val">bdns4.mywhiteserver.com</div>
                <button class="db-ns-copy" onclick="dbCopyNS('ns2val', this)" title="Copy">
                    <i class="fas fa-copy"></i>
                </button>
            </div>
        </div>
    </div>

    
    <div style="display:grid;grid-template-columns:repeat(auto-fit,minmax(140px,1fr));gap:12px;">
        <?php
        $actions = [
            ['icon'=>'fas fa-folder-open','label'=>'File Manager','route'=>'files','color'=>'#6366f1'],
            ['icon'=>'fas fa-globe','label'=>'Domains','route'=>'domains','color'=>'#3b82f6'],
            ['icon'=>'fas fa-envelope','label'=>'Emails','route'=>'emails','color'=>'#10b981'],
            ['icon'=>'fas fa-database','label'=>'Databases','route'=>'databases','color'=>'#f59e0b'],
            ['icon'=>'fas fa-lock','label'=>'SSL','route'=>'ssl','color'=>'#ec4899'],
        ];
        ?>
        <?php $__currentLoopData = $actions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $a): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <a href="<?php echo e(route($a['route'])); ?>" style="
            display:flex;flex-direction:column;align-items:center;gap:10px;
            background:#161b22;border:1px solid #21262d;border-radius:14px;
            padding:18px 12px;text-decoration:none;color:#e6edf3;
            transition:all .2s;text-align:center;
        " onmouseover="this.style.borderColor='<?php echo e($a['color']); ?>40';this.style.background='<?php echo e($a['color']); ?>0d'"
           onmouseout="this.style.borderColor='#21262d';this.style.background='#161b22'">
            <div style="width:38px;height:38px;border-radius:10px;
                background:<?php echo e($a['color']); ?>1a;color:<?php echo e($a['color']); ?>;
                display:flex;align-items:center;justify-content:center;font-size:1rem;">
                <i class="<?php echo e($a['icon']); ?>"></i>
            </div>
            <span style="font-size:.74rem;font-weight:600;"><?php echo e($a['label']); ?></span>
        </a>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>

</div>

<script>
function dbCopyNS(id, btn) {
    var txt = document.getElementById(id).textContent.trim();
    navigator.clipboard.writeText(txt).then(function() {
        var orig = btn.innerHTML;
        btn.innerHTML = '<i class="fas fa-check" style="color:#4ade80;"></i>';
        setTimeout(function(){ btn.innerHTML = orig; }, 1800);
    });
}
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.dashboard', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Program Files\Ampps\www\resources\views/dashboard/index.blade.php ENDPATH**/ ?>