<?php

use Illuminate\Support\Facades\Route;


use App\Http\Controllers\DashboardController;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\AdminController;
use App\Http\Controllers\DatabaseController;
use App\Http\Controllers\MysqlManagerController;
use App\Http\Controllers\DomainManagerController;
use App\Http\Controllers\EmailController;
use App\Http\Controllers\PhpVersionController;
use App\Http\Controllers\SoftaculousController;
use App\Http\Controllers\SslController;
use App\Http\Controllers\SupportController;
use App\Http\Controllers\BillingController;
use App\Http\Controllers\NotificationController;

// ── Billing pages (auth required but NOT subscription checked) ──────────
Route::middleware(['auth'])->group(function () {
    Route::get('/billing/expired', [BillingController::class, 'expired'])->name('billing.expired');
    Route::get('/billing/suspended', [BillingController::class, 'suspended'])->name('billing.suspended');
    // Support (accessible even when expired)
    // User notifications
    Route::get('/notifications', [NotificationController::class, 'page'])->name('notif.page');
    Route::get('/notifications/list', [NotificationController::class, 'index'])->name('notif.index');
    Route::get('/notifications/unread', [NotificationController::class, 'unread'])->name('notif.unread');
    Route::post('/notifications/{id}/read', [NotificationController::class, 'markRead'])->name('notif.read');
    Route::post('/notifications/read-all', [NotificationController::class, 'markAllRead'])->name('notif.readall');

    Route::post('/support/send', [SupportController::class, 'send'])->name('support.send');
    Route::post('/support/upload', [SupportController::class, 'upload'])->name('support.upload');
    Route::get('/support/messages', [SupportController::class, 'messages'])->name('support.messages');
    Route::get('/support/unread', [SupportController::class, 'unread'])->name('support.unread');
});

// ── Main authenticated routes (subscription check applied) ──────────────
Route::middleware(['auth', 'subscription'])->group(function () {
    Route::get('/', [DashboardController::class, 'index'])->name('dashboard');
    Route::get('/domains', [DashboardController::class, 'domains'])->name('domains');
    Route::post('/domains', [DashboardController::class, 'storeDomain'])->name('domains.store');
    Route::delete('/domains/{domain}', [DashboardController::class, 'deleteDomain'])->name('domains.delete');
    Route::get('/file-manager', [DashboardController::class, 'fileManager'])->name('files');
    Route::post('/file-manager/upload', [DashboardController::class, 'uploadFile'])->name('files.upload');
    Route::post('/file-manager/folder', [DashboardController::class, 'createFolder'])->name('files.folder');
    Route::post('/file-manager/file', [DashboardController::class, 'createNewFile'])->name('files.newfile');
    Route::post('/file-manager/delete', [DashboardController::class, 'deleteFile'])->name('files.delete');
    Route::get('/file-manager/edit', [DashboardController::class, 'editFile'])->name('files.edit');
    Route::post('/file-manager/save', [DashboardController::class, 'saveFile'])->name('files.save');
    Route::post('/file-manager/extract', [DashboardController::class, 'extractFile'])->name('files.extract');
    Route::post('/file-manager/rename', [DashboardController::class, 'renameFile'])->name('files.rename');
    Route::post('/file-manager/copy', [DashboardController::class, 'copyFile'])->name('files.copy');
    Route::post('/file-manager/move', [DashboardController::class, 'moveFile'])->name('files.move');
    Route::post('/file-manager/compress', [DashboardController::class, 'compressFiles'])->name('files.compress');
    Route::post('/file-manager/compress-download', [DashboardController::class, 'compressAndDownload'])->name('files.compress.download');
    Route::get('/file-manager/download', [DashboardController::class, 'downloadFile'])->name('files.download');
    Route::post('/file-manager/permissions', [DashboardController::class, 'changePermissions'])->name('files.permissions');
    // Database Management
    Route::get('/databases', [DatabaseController::class, 'index'])->name('databases');
    Route::post('/databases/create', [DatabaseController::class, 'createDatabase'])->name('db.create');
    Route::post('/databases/delete', [DatabaseController::class, 'deleteDatabase'])->name('db.delete');
    Route::post('/databases/users/create', [DatabaseController::class, 'createUser'])->name('db.user.create');
    Route::post('/databases/users/delete', [DatabaseController::class, 'deleteUser'])->name('db.user.delete');
    Route::post('/databases/users/password', [DatabaseController::class, 'changePassword'])->name('db.user.password');
    Route::post('/databases/assign', [DatabaseController::class, 'assignUser'])->name('db.assign');
    Route::post('/databases/revoke', [DatabaseController::class, 'revokeUser'])->name('db.revoke');
    Route::get('/databases/phpmyadmin', [DatabaseController::class, 'phpMyAdmin'])->name('db.phpmyadmin');

    // MySQL Manager
    Route::get('/mysql/{db}', [MysqlManagerController::class, 'index'])->name('mysql.index');
    Route::post('/mysql/connect', [MysqlManagerController::class, 'connect'])->name('mysql.connect');
    Route::get('/mysql/{db}/disconnect', [MysqlManagerController::class, 'disconnect'])->name('mysql.disconnect');
    Route::get('/mysql/{db}/browse/{table}', [MysqlManagerController::class, 'browse'])->name('mysql.browse');
    Route::get('/mysql/{db}/structure/{table}', [MysqlManagerController::class, 'structure'])->name('mysql.structure');
    Route::post('/mysql/{db}/query', [MysqlManagerController::class, 'query'])->name('mysql.query');
    Route::post('/mysql/{db}/import', [MysqlManagerController::class, 'import'])->name('mysql.import');
    Route::get('/mysql/{db}/export', [MysqlManagerController::class, 'export'])->name('mysql.export');
    Route::delete('/mysql/{db}/table/{table}', [MysqlManagerController::class, 'dropTable'])->name('mysql.drop');
    Route::post('/mysql/{db}/truncate/{table}', [MysqlManagerController::class, 'truncateTable'])->name('mysql.truncate');
    Route::get('/mysql/{db}/columns/{table}', [MysqlManagerController::class, 'getColumns'])->name('mysql.columns');
    Route::post('/mysql/{db}/insert/{table}', [MysqlManagerController::class, 'insertRow'])->name('mysql.insert');
    Route::post('/mysql/{db}/update/{table}', [MysqlManagerController::class, 'updateRow'])->name('mysql.update');
    Route::delete('/mysql/{db}/row/{table}', [MysqlManagerController::class, 'deleteRow'])->name('mysql.row.delete');
    Route::post('/mysql/{db}/create-table', [MysqlManagerController::class, 'createTable'])->name('mysql.create.table');
    Route::get('/mysql/{db}/export-table/{table}', [MysqlManagerController::class, 'exportTable'])->name('mysql.export.table');

    // Domain Manager
    Route::get('/domain-manager', [DomainManagerController::class, 'index'])->name('domain.manager');
    Route::get('/domain-manager/{domain}/dns', [DomainManagerController::class, 'getDns'])->name('domain.dns');
    Route::post('/domain-manager/{domain}/dns', [DomainManagerController::class, 'addDns'])->name('domain.dns.add');
    Route::delete('/domain-manager/{domain}/dns', [DomainManagerController::class, 'deleteDns'])->name('domain.dns.delete');
    Route::post('/domain-manager/subdomain/create', [DomainManagerController::class, 'createSubdomain'])->name('domain.sub.create');
    Route::delete('/domain-manager/subdomain/delete', [DomainManagerController::class, 'deleteSubdomain'])->name('domain.sub.delete');

    // PHP Version Manager
    Route::get('/php-version', [PhpVersionController::class, 'index'])->name('php.version');
    Route::post('/php-version/set', [PhpVersionController::class, 'setVersion'])->name('php.version.set');
    Route::get('/php-version/debug', [PhpVersionController::class, 'debugApi'])->name('php.version.debug');

    // Softaculous / App Installer
    Route::get('/softaculous', [SoftaculousController::class, 'index'])->name('softaculous');
    Route::get('/softaculous/go', [SoftaculousController::class, 'go'])->name('softaculous.go');

    // SSL / TLS Manager
    Route::get('/ssl', [SslController::class, 'index'])->name('ssl');
    Route::post('/ssl/autossl', [SslController::class, 'runAutoSsl'])->name('ssl.autossl');
    Route::post('/ssl/check', [SslController::class, 'checkDomain'])->name('ssl.check');
    Route::delete('/ssl/remove', [SslController::class, 'removeSsl'])->name('ssl.remove');

    // Email Manager
    Route::get('/emails', [EmailController::class, 'index'])->name('emails');
    Route::post('/emails/create', [EmailController::class, 'create'])->name('email.create');
    Route::delete('/emails/delete', [EmailController::class, 'delete'])->name('email.delete');
    Route::post('/emails/password', [EmailController::class, 'changePassword'])->name('email.password');
    Route::get('/emails/webmail', [EmailController::class, 'webmail'])->name('email.webmail');

    Route::post('/logout', [AuthController::class, 'logout'])->name('logout');

    // Admin Specific Routes
    Route::middleware(['admin'])->prefix('admin')->group(function () {
        Route::get('/clients', [AdminController::class, 'index'])->name('admin.clients');
        Route::post('/clients', [AdminController::class, 'storeClient'])->name('admin.clients.store');
        Route::get('/clients/{id}/data', [AdminController::class, 'clientData'])->name('admin.clients.data');
        Route::put('/clients/{id}', [AdminController::class, 'editClient'])->name('admin.clients.edit');
        Route::delete('/clients/{id}', [AdminController::class, 'deleteClient'])->name('admin.clients.delete');
        // Notices
        Route::post('/notices', [AdminController::class, 'storeNotice'])->name('admin.notices.store');
        Route::put('/notices/{id}', [AdminController::class, 'updateNotice'])->name('admin.notices.update');
        Route::delete('/notices/{id}', [AdminController::class, 'deleteNotice'])->name('admin.notices.delete');
        // Support chat
        Route::get('/support/{userId}', [AdminController::class, 'chatIndex'])->name('admin.support.chat');
        Route::post('/support/{userId}/reply', [AdminController::class, 'chatReply'])->name('admin.support.reply');
        Route::post('/support/{userId}/upload', [AdminController::class, 'chatUpload'])->name('admin.support.upload');
        Route::post('/support/{userId}/agent', [AdminController::class, 'agentEvent'])->name('admin.support.agent');
        // Settings + redirect control
        // Admin notifications
        Route::get('/notifications', [NotificationController::class, 'adminIndex'])->name('admin.notif.index');
        Route::post('/notifications', [NotificationController::class, 'store'])->name('admin.notif.store');
        Route::delete('/notifications/{id}', [NotificationController::class, 'destroy'])->name('admin.notif.delete');

        Route::post('/settings', [AdminController::class, 'saveSettings'])->name('admin.settings.save');
        Route::post('/settings/tools', [AdminController::class, 'runTool'])->name('admin.settings.tool');
        Route::get('/unread-count', [AdminController::class, 'unreadCount'])->name('admin.unread');
        Route::post('/clients/{id}/redirect', [AdminController::class, 'toggleRedirect'])->name('admin.clients.redirect');

        // New Client Management Routes
        Route::get('/clients/{id}/manage', [AdminController::class, 'manageClient'])->name('admin.clients.manage');
        Route::post('/clients/{id}/subdomains', [AdminController::class, 'createClientSubdomain'])->name('admin.clients.subdomain.create');
        Route::delete('/clients/{id}/subdomains', [AdminController::class, 'deleteClientSubdomain'])->name('admin.clients.subdomain.delete');
        Route::get('/clients/{id}/files', [AdminController::class, 'clientFiles'])->name('admin.clients.files');
    });
});

Route::middleware(['guest'])->group(function () {
    Route::get('/login', [AuthController::class, 'showLogin'])->name('login');
    Route::post('/login', [AuthController::class, 'login']);
});

// ── Public: Hosting expired page (shown on domain redirect, no auth) ────────
Route::get('/hosting-expired', [BillingController::class, 'hostingExpired'])->name('hosting.expired');


