@extends('layouts.dashboard')

@section('content')
<style>
/* ── Notification Page ── */
.np-wrap {
    max-width: 820px;
    margin: 0 auto;
    padding: 24px 20px 60px;
}
.np-header {
    display: flex;
    align-items: center;
    justify-content: space-between;
    margin-bottom: 24px;
    flex-wrap: wrap;
    gap: 12px;
}
.np-title {
    display: flex;
    align-items: center;
    gap: 12px;
}
.np-title-icon {
    width: 44px;
    height: 44px;
    border-radius: 14px;
    background: linear-gradient(135deg, #ef4444, #b91c1c);
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 1.1rem;
    color: #fff;
    flex-shrink: 0;
    box-shadow: 0 4px 16px rgba(239,68,68,.4);
}
.np-title h1 {
    font-size: 1.15rem;
    font-weight: 800;
    color: #e6edf3;
    margin: 0;
}
.np-title span {
    font-size: .74rem;
    color: #8b949e;
    display: block;
    margin-top: 2px;
}
.np-unread-badge {
    display: inline-flex;
    align-items: center;
    gap: 5px;
    background: rgba(239,68,68,.15);
    border: 1px solid rgba(239,68,68,.35);
    color: #fca5a5;
    padding: 4px 12px;
    border-radius: 20px;
    font-size: .75rem;
    font-weight: 700;
}
.np-actions {
    display: flex;
    align-items: center;
    gap: 10px;
}
.np-btn-readall {
    display: flex;
    align-items: center;
    gap: 7px;
    padding: 8px 16px;
    background: rgba(99,102,241,.12);
    border: 1px solid rgba(99,102,241,.3);
    border-radius: 10px;
    color: #a5b4fc;
    font-size: .78rem;
    font-weight: 700;
    cursor: pointer;
    transition: all .18s;
}
.np-btn-readall:hover {
    background: rgba(99,102,241,.22);
    border-color: rgba(99,102,241,.5);
}
.np-btn-readall:disabled {
    opacity: .4;
    cursor: not-allowed;
}

/* ── Notification items ── */
.np-list {
    display: flex;
    flex-direction: column;
    gap: 10px;
}
.np-item {
    display: flex;
    align-items: flex-start;
    gap: 14px;
    padding: 16px 18px;
    border-radius: 14px;
    border: 1px solid #21262d;
    background: #161b22;
    cursor: pointer;
    transition: all .2s;
    position: relative;
    overflow: hidden;
}
.np-item:hover {
    background: #1c2128;
    border-color: #30363d;
    transform: translateY(-1px);
    box-shadow: 0 4px 20px rgba(0,0,0,.25);
}
/* UNREAD — red highlight */
.np-item.unread {
    background: rgba(239,68,68,.06);
    border-color: rgba(239,68,68,.3);
    box-shadow: 0 0 0 1px rgba(239,68,68,.1), inset 4px 0 0 #ef4444;
}
.np-item.unread:hover {
    background: rgba(239,68,68,.1);
    border-color: rgba(239,68,68,.45);
}
/* Type accent line */
.np-item::before {
    content: '';
    position: absolute;
    left: 0;
    top: 0;
    bottom: 0;
    width: 4px;
    border-radius: 14px 0 0 14px;
}
.np-item.read::before { background: #30363d; }
.np-item.unread.type-info::before,
.np-item.read.type-info::before { background: #3b82f6; }
.np-item.unread.type-success::before,
.np-item.read.type-success::before { background: #22c55e; }
.np-item.unread.type-warning::before,
.np-item.read.type-warning::before { background: #f59e0b; }
.np-item.unread.type-danger::before,
.np-item.read.type-danger::before { background: #ef4444; }

.np-icon {
    width: 40px;
    height: 40px;
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: .95rem;
    flex-shrink: 0;
    margin-top: 2px;
}
.np-icon.type-info    { background: rgba(59,130,246,.12);  color: #60a5fa; }
.np-icon.type-success { background: rgba(34,197,94,.1);   color: #4ade80; }
.np-icon.type-warning { background: rgba(245,158,11,.1);  color: #fbbf24; }
.np-icon.type-danger  { background: rgba(239,68,68,.12);  color: #f87171; }

.np-body { flex: 1; min-width: 0; }
.np-item-title {
    font-size: .88rem;
    font-weight: 700;
    color: #e6edf3;
    margin-bottom: 4px;
    line-height: 1.35;
}
.np-item.unread .np-item-title {
    color: #fff;
}
.np-item-msg {
    font-size: .78rem;
    color: #8b949e;
    line-height: 1.55;
}
.np-item.unread .np-item-msg {
    color: #b0b8c8;
}
.np-item-meta {
    display: flex;
    align-items: center;
    justify-content: space-between;
    margin-top: 8px;
    gap: 8px;
    flex-wrap: wrap;
}
.np-item-time {
    font-size: .67rem;
    color: #475569;
    display: flex;
    align-items: center;
    gap: 4px;
}
.np-unread-pill {
    display: inline-flex;
    align-items: center;
    gap: 4px;
    background: rgba(239,68,68,.15);
    border: 1px solid rgba(239,68,68,.3);
    color: #fca5a5;
    font-size: .62rem;
    font-weight: 700;
    padding: 2px 8px;
    border-radius: 10px;
    letter-spacing: .03em;
    text-transform: uppercase;
}
.np-read-btn {
    background: rgba(99,102,241,.1);
    border: 1px solid rgba(99,102,241,.2);
    color: #818cf8;
    font-size: .66rem;
    font-weight: 600;
    padding: 3px 10px;
    border-radius: 8px;
    cursor: pointer;
    transition: all .15s;
    white-space: nowrap;
}
.np-read-btn:hover {
    background: rgba(99,102,241,.2);
    border-color: rgba(99,102,241,.4);
}

/* ── Empty state ── */
.np-empty {
    display: flex;
    flex-direction: column;
    align-items: center;
    justify-content: center;
    padding: 80px 24px;
    gap: 16px;
    color: #475569;
}
.np-empty-icon {
    width: 80px;
    height: 80px;
    border-radius: 50%;
    background: #1c2128;
    border: 2px solid #21262d;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 2rem;
    opacity: .5;
}
.np-empty h3 { font-size: .95rem; font-weight: 700; color: #6b7280; }
.np-empty p  { font-size: .78rem; color: #475569; text-align: center; }

/* ── Sound indicator ── */
.np-sound-bar {
    display: flex;
    align-items: center;
    gap: 10px;
    background: rgba(239,68,68,.08);
    border: 1px solid rgba(239,68,68,.25);
    border-radius: 12px;
    padding: 10px 16px;
    margin-bottom: 18px;
    font-size: .78rem;
    color: #fca5a5;
    font-weight: 600;
}
.np-sound-bar i { font-size: .9rem; animation: soundPulse 1s ease-in-out infinite; }
@keyframes soundPulse { 0%,100%{opacity:1;transform:scale(1);} 50%{opacity:.5;transform:scale(.88);} }
.np-sound-mute {
    margin-left: auto;
    background: rgba(239,68,68,.15);
    border: 1px solid rgba(239,68,68,.3);
    color: #fca5a5;
    font-size: .67rem;
    font-weight: 700;
    padding: 3px 10px;
    border-radius: 8px;
    cursor: pointer;
    transition: all .15s;
}
.np-sound-mute:hover { background: rgba(239,68,68,.25); }
</style>

<div class="np-wrap">
    {{-- Header --}}
    <div class="np-header">
        <div class="np-title">
            <div class="np-title-icon">
                <i class="fas fa-bell"></i>
            </div>
            <div>
                <h1>Notifications</h1>
                <span>Your alerts and updates</span>
            </div>
        </div>
        <div class="np-actions">
            @if($unread > 0)
            <span class="np-unread-badge">
                <i class="fas fa-circle" style="font-size:.45rem;"></i>
                {{ $unread }} unread
            </span>
            @endif
            <button class="np-btn-readall" id="npReadAllBtn" onclick="npMarkAllRead()"
                {{ $unread === 0 ? 'disabled' : '' }}>
                <i class="fas fa-check-double"></i> Mark all read
            </button>
        </div>
    </div>

    {{-- Sound alert bar (shown only when unread exist) --}}
    <div id="npSoundBar" class="np-sound-bar" style="{{ $unread === 0 ? 'display:none;' : '' }}">
        <i class="fas fa-volume-up" id="npSoundIcon"></i>
        <span>You have <strong id="npSoundCount">{{ $unread }}</strong> unread notification{{ $unread > 1 ? 's' : '' }}. Sound will stop when you read them.</span>
        <button class="np-sound-mute" id="npMuteBtn" onclick="npToggleMute()">
            <i class="fas fa-volume-mute"></i> Mute
        </button>
    </div>

    {{-- Notification list --}}
    <div class="np-list" id="npList">
        @if($notifications->isEmpty())
        <div class="np-empty">
            <div class="np-empty-icon"><i class="fas fa-bell-slash"></i></div>
            <h3>No notifications yet</h3>
            <p>When admin sends you a notification, it will appear here.</p>
        </div>
        @else
            @foreach($notifications as $n)
            @php
                $icons = [
                    'info'    => 'fas fa-info-circle',
                    'success' => 'fas fa-check-circle',
                    'warning' => 'fas fa-exclamation-triangle',
                    'danger'  => 'fas fa-times-circle',
                ];
                $icon = $n['icon'] ?? ($icons[$n['type']] ?? 'fas fa-bell');
            @endphp
            <div class="np-item {{ $n['is_read'] ? 'read' : 'unread' }} type-{{ $n['type'] }}"
                 id="npItem{{ $n['id'] }}" data-id="{{ $n['id'] }}" data-read="{{ $n['is_read'] ? '1' : '0' }}">
                <div class="np-icon type-{{ $n['type'] }}">
                    <i class="{{ $icon }}"></i>
                </div>
                <div class="np-body">
                    <div class="np-item-title">{{ $n['title'] }}</div>
                    <div class="np-item-msg">{{ $n['message'] }}</div>
                    <div class="np-item-meta">
                        <span class="np-item-time">
                            <i class="fas fa-clock" style="font-size:.6rem;"></i>
                            {{ $n['date'] }} &nbsp;·&nbsp; {{ $n['created_at'] }}
                        </span>
                        @if(!$n['is_read'])
                        <div style="display:flex;align-items:center;gap:8px;">
                            <span class="np-unread-pill"><i class="fas fa-circle" style="font-size:.4rem;"></i> Unread</span>
                            <button class="np-read-btn" onclick="npMarkRead({{ $n['id'] }}, event)">
                                <i class="fas fa-check"></i> Mark read
                            </button>
                        </div>
                        @endif
                    </div>
                </div>
            </div>
            @endforeach
        @endif
    </div>
</div>

<script>
var NP_READALL  = '{{ route("notif.readall") }}';
var NP_READ_URL = '{{ url("/notifications") }}';
var NP_CSRF     = document.querySelector('meta[name="csrf-token"]')?.content || '{{ csrf_token() }}';
var npMuted     = false;
var npSoundLoop = null;
var npUnread    = {{ $unread }};

// ── Sound: loop while unread > 0 ──────────────────────────────
function npStartSound() {
    if (npMuted || npUnread === 0) return;
    spPlaySound();
    if (!npSoundLoop) {
        npSoundLoop = setInterval(function() {
            if (!npMuted && npUnread > 0) spPlaySound();
            else { clearInterval(npSoundLoop); npSoundLoop = null; }
        }, 8000);
    }
}

function npStopSound() {
    if (npSoundLoop) { clearInterval(npSoundLoop); npSoundLoop = null; }
}

function npToggleMute() {
    npMuted = !npMuted;
    var btn = document.getElementById('npMuteBtn');
    if (npMuted) {
        npStopSound();
        btn.innerHTML = '<i class="fas fa-volume-up"></i> Unmute';
        document.getElementById('npSoundIcon').style.animationPlayState = 'paused';
    } else {
        btn.innerHTML = '<i class="fas fa-volume-mute"></i> Mute';
        document.getElementById('npSoundIcon').style.animationPlayState = 'running';
        npStartSound();
    }
}

// ── Update UI state ───────────────────────────────────────────
function npUpdateState() {
    var soundBar = document.getElementById('npSoundBar');
    var readAllBtn = document.getElementById('npReadAllBtn');
    var countEl  = document.getElementById('npSoundCount');
    if (soundBar) soundBar.style.display = npUnread > 0 ? 'flex' : 'none';
    if (countEl)  countEl.textContent = npUnread;
    if (readAllBtn) readAllBtn.disabled = npUnread === 0;

    // Update topbar bell badge
    if (typeof spUpdateBells === 'function') spUpdateBells(npUnread);

    if (npUnread === 0) npStopSound();
    else if (!npMuted)  npStartSound();
}

// ── Mark single read ──────────────────────────────────────────
function npMarkRead(id, e) {
    if (e) e.stopPropagation();
    var item = document.getElementById('npItem' + id);
    if (!item || item.dataset.read === '1') return;

    fetch(NP_READ_URL + '/' + id + '/read', {
        method: 'POST',
        headers: { 'X-CSRF-TOKEN': NP_CSRF, 'Accept': 'application/json' }
    }).then(function() {
        item.classList.remove('unread');
        item.classList.add('read');
        item.dataset.read = '1';
        // Remove unread pill and read btn
        var meta = item.querySelector('.np-item-meta');
        if (meta) {
            var pills = meta.querySelectorAll('.np-unread-pill, .np-read-btn');
            pills.forEach(function(p) { p.parentElement.remove(); });
        }
        npUnread = Math.max(0, npUnread - 1);
        npUpdateState();
    });
}

// ── Mark all read ─────────────────────────────────────────────
function npMarkAllRead() {
    fetch(NP_READALL, {
        method: 'POST',
        headers: { 'X-CSRF-TOKEN': NP_CSRF, 'Accept': 'application/json' }
    }).then(function() {
        document.querySelectorAll('.np-item.unread').forEach(function(item) {
            item.classList.remove('unread');
            item.classList.add('read');
            item.dataset.read = '1';
            var meta = item.querySelector('.np-item-meta');
            if (meta) {
                var pills = meta.querySelectorAll('.np-unread-pill, .np-read-btn');
                pills.forEach(function(p) { p.parentElement.remove(); });
            }
        });
        npUnread = 0;
        npUpdateState();
    });
}

// Also clicking the item marks it read
document.querySelectorAll('.np-item').forEach(function(item) {
    item.addEventListener('click', function() {
        var id = parseInt(item.dataset.id);
        if (item.dataset.read === '0') npMarkRead(id, null);
    });
});

// Start loop on load if there are unread notifications
if (npUnread > 0) npStartSound();
</script>
@endsection
