@extends('layouts.dashboard')

@section('styles')
<style>
.sc-wrap{color:#e6edf3;}
.sc-header{margin-bottom:24px;}
.sc-header h2{font-size:1.15rem;display:flex;align-items:center;gap:10px;margin-bottom:6px;}
.sc-header h2 i{color:#3fb950;}
.sc-header p{font-size:.8rem;color:#8b949e;}

/* Search */
.sc-search-wrap{position:relative;margin-bottom:22px;}
.sc-search{width:100%;max-width:420px;background:#161b22;border:1px solid #30363d;border-radius:10px;color:#e6edf3;padding:10px 16px 10px 40px;font-size:.85rem;outline:none;font-family:inherit;}
.sc-search:focus{border-color:#58a6ff;}
.sc-search-ico{position:absolute;left:13px;top:50%;transform:translateY(-50%);color:#8b949e;pointer-events:none;}

/* Category */
.sc-cat-title{font-size:.7rem;font-weight:700;text-transform:uppercase;letter-spacing:.1em;color:#8b949e;margin:0 0 10px;}

/* App grid */
.sc-grid{display:grid;grid-template-columns:repeat(auto-fill,minmax(200px,1fr));gap:12px;margin-bottom:28px;}
.sc-app-card{background:#161b22;border:1px solid #30363d;border-radius:12px;padding:18px;cursor:pointer;transition:all .15s;position:relative;overflow:hidden;user-select:none;}
.sc-app-card:hover{border-color:#58a6ff;transform:translateY(-2px);box-shadow:0 8px 24px rgba(0,0,0,.35);}
.sc-app-card:active{transform:translateY(0);}
.sc-app-card::before{content:'';position:absolute;inset:0;opacity:0;transition:opacity .2s;background:radial-gradient(circle at top left,rgba(88,166,255,.06),transparent 60%);pointer-events:none;}
.sc-app-card:hover::before{opacity:1;}
.sc-app-icon{width:44px;height:44px;border-radius:12px;display:flex;align-items:center;justify-content:center;font-size:1.2rem;margin-bottom:12px;flex-shrink:0;pointer-events:none;}
.sc-app-name{font-weight:700;font-size:.88rem;margin-bottom:4px;pointer-events:none;}
.sc-app-desc{font-size:.71rem;color:#8b949e;line-height:1.4;margin-bottom:12px;min-height:34px;pointer-events:none;}
.sc-install-btn{display:inline-flex;align-items:center;gap:5px;padding:5px 14px;border-radius:7px;font-size:.74rem;font-weight:700;border:1px solid #3fb950;background:rgba(63,185,80,.12);color:#3fb950;cursor:pointer;pointer-events:none;transition:all .13s;}
.sc-app-card:hover .sc-install-btn{background:#3fb950;color:#000;}

/* Modal overlay */
.sc-overlay{display:none;position:fixed;inset:0;background:rgba(0,0,0,.75);backdrop-filter:blur(6px);z-index:1000;align-items:center;justify-content:center;}
.sc-overlay.show{display:flex !important;}
.sc-modal{background:#161b22;border:1px solid #30363d;border-radius:16px;width:min(480px,92vw);padding:28px;}
.sc-modal-head{display:flex;align-items:center;gap:14px;margin-bottom:20px;}
.sc-modal-icon{width:48px;height:48px;border-radius:12px;display:flex;align-items:center;justify-content:center;font-size:1.4rem;flex-shrink:0;}
.sc-modal-title{font-size:1.05rem;font-weight:700;}
.sc-modal-sub{font-size:.75rem;color:#8b949e;margin-top:2px;}
.sc-field{margin-bottom:14px;}
.sc-field label{display:block;font-size:.73rem;color:#8b949e;margin-bottom:5px;}
.sc-field select,.sc-field input{width:100%;background:#21262d;border:1px solid #30363d;border-radius:8px;color:#e6edf3;padding:8px 12px;font-size:.82rem;outline:none;font-family:inherit;}
.sc-field select:focus,.sc-field input:focus{border-color:#58a6ff;}
.sc-field select option{background:#1c2128;color:#e6edf3;}
.sc-modal-footer{display:flex;gap:8px;justify-content:flex-end;margin-top:18px;border-top:1px solid #30363d;padding-top:16px;}
.sc-btn{display:inline-flex;align-items:center;gap:6px;padding:8px 18px;border-radius:8px;font-size:.8rem;font-weight:700;cursor:pointer;border:1px solid;font-family:inherit;transition:all .13s;}
.sc-btn.green{background:rgba(63,185,80,.12);border-color:#3fb950;color:#3fb950;}
.sc-btn.green:hover{background:#3fb950;color:#000;}
.sc-btn.ghost{background:transparent;border-color:#30363d;color:#8b949e;}
.sc-btn.ghost:hover{border-color:#58a6ff;color:#58a6ff;}
.sc-info{background:rgba(88,166,255,.07);border:1px solid rgba(88,166,255,.2);border-radius:9px;padding:10px 14px;font-size:.76rem;color:#58a6ff;margin-bottom:16px;line-height:1.5;}

/* Responsive */
@media (max-width: 520px) {
    .sc-grid { grid-template-columns: 1fr 1fr; }
    .sc-app-card { padding: 12px; }
    .sc-app-icon { width: 34px; height: 34px; font-size: 1rem; }
    .sc-modal { padding: 18px; }
}
@media (max-width: 360px) {
    .sc-grid { grid-template-columns: 1fr; }
}
</style>
@endsection

@section('content')
<div class="sc-wrap">
    <div class="sc-header">
        <h2><i class="fas fa-rocket"></i> App Installer</h2>
        <p>One-click installation of popular web applications on your domains via Softaculous.</p>
    </div>

    <div class="sc-search-wrap">
        <i class="fas fa-search sc-search-ico"></i>
        <input type="text" class="sc-search" id="scSearch" placeholder="Search applications…">
    </div>

    @foreach($apps as $category => $appList)
    <div class="sc-cat-section" data-cat="{{ $category }}">
        <p class="sc-cat-title"><i class="fas fa-tag" style="margin-right:5px;"></i>{{ $category }}</p>
        <div class="sc-grid" id="scgrid-{{ Str::slug($category) }}">
            @foreach($appList as $app)
            {{-- Entire card is clickable — onclick="scOpenModal(...)" --}}
            <div class="sc-app-card"
                 onclick="scOpenModal({{ $app['id'] }}, '{{ addslashes($app['name']) }}', '{{ $app['icon'] }}', '{{ $app['color'] }}')"
                 data-name="{{ strtolower($app['name']) }}"
                 data-desc="{{ strtolower($app['desc']) }}">
                <div class="sc-app-icon" style="background:{{ $app['color'] }}22;color:{{ $app['color'] }};">
                    <i class="{{ $app['icon'] }}"></i>
                </div>
                <div class="sc-app-name">{{ $app['name'] }}</div>
                <div class="sc-app-desc">{{ $app['desc'] }}</div>
                <span class="sc-install-btn"><i class="fas fa-download"></i> Install</span>
            </div>
            @endforeach
        </div>
    </div>
    @endforeach
</div>
@endsection

@section('scripts')
{{-- ── Install Modal — rendered outside .sp-content to avoid z-index issues ── --}}
<div class="sc-overlay" id="scModal">
    <div class="sc-modal" onclick="event.stopPropagation()">
        <div class="sc-modal-head">
            <div class="sc-modal-icon" id="scIcon"></div>
            <div>
                <div class="sc-modal-title" id="scTitle">Install App</div>
                <div class="sc-modal-sub">Select your domain and click Open Installer</div>
            </div>
        </div>

        <div class="sc-info">
            <i class="fas fa-info-circle" style="margin-right:6px;"></i>
            Opens <strong>Softaculous</strong> in cPanel — you will be auto-logged in.
        </div>

        <form id="scForm"
              action="{{ route('softaculous.go') }}"
              method="GET"
              target="_blank">
            <input type="hidden" name="soft_id" id="scSoftId" value="0">

            <div class="sc-field">
                <label><i class="fas fa-globe" style="margin-right:4px;"></i> Install on Domain</label>
                <select name="domain" id="scDomain">
                    @foreach($userDomains as $dom)
                    <option value="{{ $dom }}">{{ $dom }}</option>
                    @endforeach
                </select>
            </div>

            <div class="sc-field">
                <label>
                    <i class="fas fa-folder" style="margin-right:4px;"></i>
                    Sub-directory
                    <span style="font-size:.68rem;color:#8b949e;">(leave blank for root)</span>
                </label>
                <input type="text" name="dir" id="scDir" placeholder="e.g. blog, shop">
            </div>

            <div class="sc-modal-footer">
                <button type="button" class="sc-btn ghost" onclick="scCloseModal()">
                    <i class="fas fa-times"></i> Cancel
                </button>
                <button type="submit" class="sc-btn green" onclick="scCloseModal()">
                    <i class="fas fa-rocket"></i> Open Installer
                </button>
            </div>
        </form>
    </div>
</div>

<script>
// ── Open install modal ────────────────────────────────────────────────
function scOpenModal(softId, name, iconClass, color) {
    document.getElementById('scSoftId').value = softId;
    document.getElementById('scTitle').textContent = 'Install ' + name;
    document.getElementById('scDir').value = '';

    var ico = document.getElementById('scIcon');
    ico.style.background = color + '22';
    ico.style.color = color;
    ico.innerHTML = '<i class="' + iconClass + '"></i>';

    document.getElementById('scModal').classList.add('show');
}

function scCloseModal() {
    document.getElementById('scModal').classList.remove('show');
}

// Close on backdrop click
document.getElementById('scModal').addEventListener('click', function(e) {
    if (e.target === this) scCloseModal();
});

// Escape key closes modal
document.addEventListener('keydown', function(e) {
    if (e.key === 'Escape') scCloseModal();
});

// ── Search filter ─────────────────────────────────────────────────────
document.getElementById('scSearch').addEventListener('input', function() {
    var q = this.value.toLowerCase().trim();
    document.querySelectorAll('.sc-app-card').forEach(function(card) {
        var match = !q || card.dataset.name.includes(q) || card.dataset.desc.includes(q);
        card.style.display = match ? '' : 'none';
    });
    document.querySelectorAll('.sc-cat-section').forEach(function(sec) {
        var hasVisible = Array.from(sec.querySelectorAll('.sc-app-card'))
            .some(function(c){ return c.style.display !== 'none'; });
        sec.style.display = hasVisible ? '' : 'none';
    });
});
</script>
@endsection
