@extends('layouts.dashboard')

@section('styles')
    <style>
        .security-grid {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            gap: 2rem;
        }

        .security-card {
            background: var(--bg-card);
            border: 1px solid var(--border);
            padding: 2rem;
            border-radius: 24px;
            display: flex;
            gap: 1.5rem;
        }

        .security-icon {
            width: 60px;
            height: 60px;
            background: rgba(16, 185, 129, 0.1);
            color: #10b981;
            border-radius: 16px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.75rem;
            flex-shrink: 0;
        }

        .security-info h3 {
            margin-bottom: 0.5rem;
        }

        .security-info p {
            color: var(--text-muted);
            font-size: 0.9rem;
            line-height: 1.5;
            margin-bottom: 1.5rem;
        }

        .status-active {
            color: #10b981;
            font-weight: 600;
            font-size: 0.85rem;
        }
    </style>
@endsection

@section('content')
    <div class="animate-fade">
        <h2 style="margin-bottom: 2rem;">Security & Protection</h2>

        <div class="security-grid">
            <div class="security-card">
                <div class="security-icon"><i class="fas fa-shield-alt"></i></div>
                <div class="security-info">
                    <h3>SSL/TLS Status</h3>
                    <p>Your domains are protected with 256-bit encryption. All certificates are currently valid and set to
                        auto-renew.</p>
                    <div style="display: flex; justify-content: space-between; align-items: center;">
                        <span class="status-active"><i class="fas fa-check-circle"></i> Protected</span>
                        <a href="#" class="action-btn">Manage</a>
                    </div>
                </div>
            </div>

            <div class="security-card">
                <div class="security-icon" style="background: rgba(99, 102, 241, 0.1); color: var(--primary);">
                    <i class="fas fa-key"></i>
                </div>
                <div class="security-info">
                    <h3>SSH Access</h3>
                    <p>Manage your public keys for secure terminal access to your hosting account.</p>
                    <div style="display: flex; justify-content: space-between; align-items: center;">
                        <span class="status-active" style="color: var(--primary);">2 Keys Enabled</span>
                        <a href="#" class="action-btn">Configure</a>
                    </div>
                </div>
            </div>

            <div class="security-card">
                <div class="security-icon" style="background: rgba(239, 68, 68, 0.1); color: #ef4444;">
                    <i class="fas fa-user-lock"></i>
                </div>
                <div class="security-info">
                    <h3>IP Blocker</h3>
                    <p>Prevent specific IP addresses or ranges from accessing your website.</p>
                    <div style="display: flex; justify-content: space-between; align-items: center;">
                        <span class="status-active" style="color: #ef4444;">12 IPs Blocked</span>
                        <a href="#" class="action-btn">Manage List</a>
                    </div>
                </div>
            </div>

            <div class="security-card">
                <div class="security-icon" style="background: rgba(56, 189, 248, 0.1); color: var(--accent);">
                    <i class="fas fa-mask"></i>
                </div>
                <div class="security-info">
                    <h3>Hotlink Protection</h3>
                    <p>Prevent other websites from directly linking to your images and files to save bandwidth.</p>
                    <div style="display: flex; justify-content: space-between; align-items: center;">
                        <span class="status-active" style="color: var(--accent);">Disabled</span>
                        <a href="#" class="action-btn">Enable</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection