<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Opening phpMyAdmin…</title>
    <style>
        *, *::before, *::after { box-sizing: border-box; margin: 0; padding: 0; }

        body {
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            background: linear-gradient(135deg, #0f0c29, #302b63, #24243e);
            font-family: 'Segoe UI', sans-serif;
            color: #fff;
        }

        .card {
            background: rgba(255,255,255,.07);
            border: 1px solid rgba(255,255,255,.12);
            backdrop-filter: blur(18px);
            border-radius: 20px;
            padding: 48px 56px;
            text-align: center;
            max-width: 380px;
            width: 90%;
            box-shadow: 0 24px 60px rgba(0,0,0,.5);
            animation: popIn .5s cubic-bezier(.34,1.56,.64,1) both;
        }
        @keyframes popIn {
            from { opacity:0; transform:scale(.82) translateY(20px); }
            to   { opacity:1; transform:scale(1)   translateY(0);    }
        }

        /* DB icon with orbit ring */
        .icon-wrap {
            position: relative;
            width: 90px;
            height: 90px;
            margin: 0 auto 28px;
        }
        .icon-wrap svg.db-icon {
            width: 60px;
            height: 60px;
            position: absolute;
            top: 50%; left: 50%;
            transform: translate(-50%,-50%);
            filter: drop-shadow(0 0 12px #f7931a99);
        }
        .orbit {
            position: absolute;
            inset: 0;
            border: 2px solid transparent;
            border-top-color: #f7931a;
            border-radius: 50%;
            animation: spin 1s linear infinite;
        }
        .orbit2 {
            inset: 8px;
            border-top-color: #a78bfa;
            animation: spin 1.6s linear infinite reverse;
        }
        @keyframes spin { to { transform: rotate(360deg); } }

        h2 {
            font-size: 1.3rem;
            font-weight: 700;
            margin-bottom: 10px;
            letter-spacing: .01em;
        }
        p {
            font-size: .88rem;
            color: rgba(255,255,255,.65);
            line-height: 1.6;
        }

        /* Progress bar */
        .progress-track {
            width: 100%;
            height: 4px;
            background: rgba(255,255,255,.12);
            border-radius: 99px;
            margin: 28px 0 16px;
            overflow: hidden;
        }
        .progress-fill {
            height: 100%;
            width: 0%;
            background: linear-gradient(90deg, #f7931a, #a78bfa);
            border-radius: 99px;
            animation: fillBar 2.2s ease-out forwards;
        }
        @keyframes fillBar { to { width: 100%; } }

        .status {
            font-size: .78rem;
            color: rgba(255,255,255,.45);
            letter-spacing: .05em;
            text-transform: uppercase;
        }

        /* Bouncing dots */
        .dots span {
            display: inline-block;
            width: 5px; height: 5px;
            border-radius: 50%;
            background: #a78bfa;
            margin: 0 2px;
            animation: bounce .8s infinite alternate;
        }
        .dots span:nth-child(2) { animation-delay: .15s; }
        .dots span:nth-child(3) { animation-delay: .30s; }
        @keyframes bounce {
            from { transform: translateY(0);   opacity:.5; }
            to   { transform: translateY(-6px); opacity:1; }
        }
    </style>
</head>
<body>

<div class="card">
    <div class="icon-wrap">
        <div class="orbit"></div>
        <div class="orbit orbit2"></div>
        <svg class="db-icon" viewBox="0 0 64 64" fill="none" xmlns="http://www.w3.org/2000/svg">
            <ellipse cx="32" cy="16" rx="22" ry="8" fill="#f7931a" opacity=".9"/>
            <path d="M10 16v10c0 4.4 9.9 8 22 8s22-3.6 22-8V16" fill="#f7931a" opacity=".6"/>
            <path d="M10 26v10c0 4.4 9.9 8 22 8s22-3.6 22-8V26" fill="#a78bfa" opacity=".5"/>
            <path d="M10 36v10c0 4.4 9.9 8 22 8s22-3.6 22-8V36" fill="#6d28d9" opacity=".6"/>
        </svg>
    </div>

    <h2>Connecting to phpMyAdmin</h2>

    @if(!empty($error))
        <p style="color:#f87171;font-size:.82rem;margin-top:8px;">
            <i class="fas fa-exclamation-circle"></i> {{ $error }}
        </p>
        <p style="color:rgba(255,255,255,.5);font-size:.75rem;margin-top:6px;">
            Trying fallback login…
        </p>
    @else
        <p>Signing you in automatically&nbsp;<span class="dots"><span></span><span></span><span></span></span></p>
    @endif

    <div class="progress-track">
        <div class="progress-fill"></div>
    </div>

    <p class="status">Please wait, do not close this tab</p>
</div>

{{-- Fallback: hidden auto-submit form if server-side redirect failed --}}
<form id="pmaForm" method="POST" action="{{ $loginUrl }}" style="display:none;">
    <input type="hidden" name="user"      value="{{ $cpanelUser }}">
    <input type="hidden" name="api_token" value="{{ $apiToken }}">
    <input type="hidden" name="goto_uri"  value="/3rdparty/phpMyAdmin/">
</form>

<script>
    setTimeout(function () {
        document.getElementById('pmaForm').submit();
    }, 2400);
</script>
</body>
</html>
