@extends('layouts.dashboard')
@section('content')
<style>
:root{--pv-bg:#0d1117;--pv-surface:#161b22;--pv-card:#21262d;--pv-border:#30363d;--pv-blue:#58a6ff;--pv-green:#3fb950;--pv-red:#f85149;--pv-yellow:#d29922;--pv-purple:#a371f7;--pv-text:#e6edf3;--pv-muted:#8b949e;}
.pv-wrap{font-family:'Outfit',sans-serif;color:var(--pv-text);}
.pv-header{display:flex;align-items:center;gap:12px;margin-bottom:22px;}
.pv-header h2{font-size:1.15rem;display:flex;align-items:center;gap:10px;}
.pv-header h2 i{color:var(--pv-purple);}
.pv-header p{font-size:.8rem;color:var(--pv-muted);}

/* Domain cards */
.pv-grid{display:grid;grid-template-columns:repeat(auto-fill,minmax(360px,1fr));gap:16px;}
.pv-card{background:var(--pv-surface);border:1px solid var(--pv-border);border-radius:14px;padding:20px;transition:border-color .2s;}
.pv-card:hover{border-color:var(--pv-purple);}
.pv-card-head{display:flex;align-items:center;gap:12px;margin-bottom:16px;}
.pv-domain-icon{width:40px;height:40px;border-radius:10px;background:rgba(163,113,247,.15);display:flex;align-items:center;justify-content:center;font-size:1rem;color:var(--pv-purple);flex-shrink:0;}
.pv-domain-name{font-weight:700;font-size:.92rem;}
.pv-domain-type{font-size:.68rem;color:var(--pv-muted);margin-top:2px;}
.pv-cur-ver{display:inline-flex;align-items:center;gap:6px;padding:4px 12px;border-radius:20px;font-size:.73rem;font-weight:700;margin-bottom:14px;}
.pv-cur-ver.green{background:rgba(63,185,80,.12);border:1px solid rgba(63,185,80,.3);color:var(--pv-green);}
.pv-cur-ver.blue{background:rgba(88,166,255,.12);border:1px solid rgba(88,166,255,.3);color:var(--pv-blue);}
.pv-cur-ver.muted{background:rgba(139,148,158,.1);border:1px solid var(--pv-border);color:var(--pv-muted);}

/* Version selector */
.pv-selector{display:flex;gap:8px;align-items:center;}
.pv-select{flex:1;background:var(--pv-card);border:1px solid var(--pv-border);border-radius:8px;color:var(--pv-text);padding:8px 12px;font-size:.82rem;outline:none;cursor:pointer;}
.pv-select:focus{border-color:var(--pv-purple);}
.pv-save-btn{display:inline-flex;align-items:center;gap:5px;padding:8px 16px;border-radius:8px;font-size:.78rem;font-weight:700;cursor:pointer;border:1px solid var(--pv-purple);background:rgba(163,113,247,.12);color:var(--pv-purple);transition:all .13s;white-space:nowrap;}
.pv-save-btn:hover{background:var(--pv-purple);color:#fff;}
.pv-save-btn:disabled{opacity:.5;cursor:not-allowed;}

/* PHP version color coding */
.php-81,.php-82,.php-83{color:var(--pv-green);}
.php-80,.php-74{color:var(--pv-blue);}
.php-73,.php-72,.php-71,.php-70{color:var(--pv-yellow);}
.php-old{color:var(--pv-red);}

/* Empty state */
.pv-empty{padding:60px;text-align:center;color:var(--pv-muted);}
.pv-empty i{font-size:3rem;display:block;margin-bottom:14px;opacity:.3;}

/* Toast */
.pv-toast{position:fixed;bottom:24px;right:24px;z-index:9999;display:flex;flex-direction:column;gap:6px;}
.pv-toast-item{padding:10px 18px;border-radius:8px;font-size:.8rem;font-weight:600;animation:pv-slide .3s ease;box-shadow:0 6px 20px rgba(0,0,0,.4);}
.pv-toast-item.ok{background:#3fb950;color:#000;}
.pv-toast-item.err{background:#f85149;color:#fff;}
@keyframes pv-slide{from{transform:translateX(100%);opacity:0;}to{transform:translateX(0);opacity:1;}}
</style>

<div class="pv-wrap">
    <div class="pv-header">
        <div>
            <h2><i class="fab fa-php"></i> PHP Version Manager</h2>
            <p>Change the PHP version for each of your domains independently.</p>
        </div>
    </div>

    @if(empty($domains))
    <div class="pv-empty">
        <i class="fas fa-globe"></i>
        <p>No domains found. Add a domain first.</p>
    </div>
    @else


    <div class="pv-grid">
        @foreach($domains as $domain => $currentVer)
        @php
            $isPrimary = $domain === Auth::user()->primary_domain;
            $vl        = \App\Http\Controllers\PhpVersionController::versionLabel($currentVer);
            $verLabel  = $currentVer === 'inherit' ? 'System Default' : 'PHP ' . $vl;
            $verClass  = match(true) {
                in_array($vl, ['8.3','8.2','8.1']) => 'green',
                in_array($vl, ['8.0','7.4'])       => 'blue',
                $currentVer === 'inherit'           => 'muted',
                default                             => 'muted'
            };
        @endphp
        <div class="pv-card" id="pvcard-{{ md5($domain) }}">
            <div class="pv-card-head">
                <div class="pv-domain-icon"><i class="fas fa-globe"></i></div>
                <div>
                    <div class="pv-domain-name">{{ $domain }}</div>
                    <div class="pv-domain-type">{{ $isPrimary ? 'Primary Domain' : 'Addon Domain' }}</div>
                </div>
            </div>
            <div>
                <span class="pv-cur-ver {{ $verClass }}" id="curver-{{ md5($domain) }}">
                    <i class="fab fa-php"></i> {{ $verLabel }}
                </span>
            </div>
            <div class="pv-selector">
                <select class="pv-select" id="pvsel-{{ md5($domain) }}">
                    <option value="inherit" {{ $currentVer === 'inherit' ? 'selected' : '' }}>
                        System Default (inherit)
                    </option>
                    @foreach($installed as $ver)
                    @php
                        $ver = is_array($ver) ? ($ver['version'] ?? $ver['php'] ?? '') : (string)$ver;
                        $vl  = \App\Http\Controllers\PhpVersionController::versionLabel($ver);
                    @endphp
                    @if($ver)
                    <option value="{{ $ver }}" {{ $currentVer === $ver ? 'selected' : '' }}>
                        PHP {{ $vl }}
                    </option>
                    @endif
                    @endforeach
                </select>
                <button class="pv-save-btn" id="pvbtn-{{ md5($domain) }}" onclick="saveVersion('{{ $domain }}','{{ md5($domain) }}')">
                    <i class="fas fa-save"></i> Apply
                </button>
            </div>
        </div>
        @endforeach
    </div>
    @endif
</div>

<div class="pv-toast" id="pvToastArea"></div>

<script>
const CSRF = '{{ csrf_token() }}';

// ea-php83 → "8.3",  php8.1 → "8.1",  8.2 → "8.2"
function phpVerLabel(ver) {
    if (!ver || ver === 'inherit') return 'Default';
    const m = ver.match(/php(\d)(\d+)$/i);
    if (m) return m[1] + '.' + m[2];
    const m2 = ver.match(/^(\d+\.\d+)/);
    if (m2) return m2[1];
    return ver;
}

function pvToast(msg, type='ok') {
    const area = document.getElementById('pvToastArea');
    const el   = document.createElement('div');
    el.className = `pv-toast-item ${type}`;
    el.innerHTML = `<i class="fas fa-${type==='ok'?'check-circle':'exclamation-circle'}" style="margin-right:6px;"></i>${msg}`;
    area.appendChild(el);
    setTimeout(() => el.remove(), 3500);
}

async function saveVersion(domain, hash) {
    const select = document.getElementById(`pvsel-${hash}`);
    const btn    = document.getElementById(`pvbtn-${hash}`);
    const version = select.value;

    btn.innerHTML = '<i class="fas fa-circle-notch fa-spin"></i>'; btn.disabled = true;

    try {
        const r = await fetch('{{ route("php.version.set") }}', {
            method: 'POST',
            headers: {'Content-Type':'application/json','X-CSRF-TOKEN':CSRF,'X-Requested-With':'XMLHttpRequest'},
            body: JSON.stringify({ domain, version }),
        });
        const d = await r.json();

        btn.innerHTML = '<i class="fas fa-save"></i> Apply'; btn.disabled = false;

        if (!d.success) return pvToast(d.message || 'Failed', 'err');

        // Update badge
        const badge  = document.getElementById(`curver-${hash}`);
        const vLabel = version === 'inherit' ? 'System Default' : 'PHP ' + phpVerLabel(version);
        badge.innerHTML = `<i class="fab fa-php"></i> ${vLabel}`;
        const vNum = phpVerLabel(version);
        badge.className = 'pv-cur-ver ' + (
            ['8.3','8.2','8.1'].includes(vNum) ? 'green' :
            ['8.0','7.4'].includes(vNum)        ? 'blue' : 'muted'
        );
        pvToast(`PHP version updated for ${domain}!`);
    } catch(e) {
        btn.innerHTML = '<i class="fas fa-save"></i> Apply'; btn.disabled = false;
        pvToast(e.message, 'err');
    }
}
</script>
@endsection
