@extends('layouts.dashboard')

@section('content')
@php
$csrfToken = csrf_token();
$urlBase   = url('/mysql/' . $db);
@endphp
<style>
/* ══════════════════════════════════════════════════════
   phpMyAdmin-style MySQL Manager
══════════════════════════════════════════════════════ */
:root{
  --pma-bg:#1a1d23;--pma-sidebar:#13161b;--pma-header:#1e2128;
  --pma-border:#2d3139;--pma-blue:#4e9de0;--pma-green:#5cb85c;
  --pma-red:#d9534f;--pma-orange:#f0ad4e;--pma-purple:#9b59b6;
  --pma-text:#cdd6f4;--pma-muted:#6c7086;--pma-row:#1e2128;
  --pma-row-alt:#212530;--pma-input:#2a2d36;
}
*{box-sizing:border-box;margin:0;padding:0;}
.pma-wrap{display:flex;height:calc(100vh - 0px);overflow:hidden;background:var(--pma-bg);border-radius:12px;border:1px solid var(--pma-border);font-size:13px;color:var(--pma-text);font-family:'Outfit','Segoe UI',sans-serif;}

/* ── Sidebar ── */
.pma-sidebar{width:210px;min-width:210px;background:var(--pma-sidebar);border-right:1px solid var(--pma-border);display:flex;flex-direction:column;overflow:hidden;}
.pma-sidebar-logo{padding:12px 14px;border-bottom:1px solid var(--pma-border);display:flex;align-items:center;gap:8px;}
.pma-sidebar-logo .logo-icon{font-size:1.3rem;color:var(--pma-orange);}
.pma-sidebar-logo .logo-text{font-size:.9rem;font-weight:700;color:var(--pma-text);}
.pma-sidebar-logo .logo-sub{font-size:.65rem;color:var(--pma-muted);}
.pma-db-label{padding:8px 14px 4px;font-size:.65rem;text-transform:uppercase;letter-spacing:.06em;color:var(--pma-muted);font-weight:700;}
.pma-db-item{display:flex;align-items:center;gap:6px;padding:6px 14px;color:var(--pma-blue);font-size:.8rem;font-weight:600;background:rgba(78,157,224,.08);border-left:2px solid var(--pma-blue);}
.pma-search-box{padding:6px 10px;border-bottom:1px solid var(--pma-border);}
.pma-search-box input{width:100%;background:var(--pma-input);border:1px solid var(--pma-border);border-radius:4px;color:var(--pma-text);padding:4px 8px;font-size:.75rem;outline:none;}
.pma-search-box input:focus{border-color:var(--pma-blue);}
.pma-tbl-list{flex:1;overflow-y:auto;padding:2px 0;}
.pma-tbl-list::-webkit-scrollbar{width:4px;}.pma-tbl-list::-webkit-scrollbar-thumb{background:var(--pma-border);border-radius:2px;}
.pma-tbl-item{display:flex;align-items:center;gap:6px;padding:5px 14px;cursor:pointer;color:var(--pma-muted);font-size:.77rem;transition:all .12s;border-left:2px solid transparent;}
.pma-tbl-item:hover{background:rgba(255,255,255,.04);color:var(--pma-text);}
.pma-tbl-item.active{background:rgba(78,157,224,.08);color:var(--pma-blue);border-left-color:var(--pma-blue);}
.pma-tbl-item i{font-size:.7rem;flex-shrink:0;}
.pma-tbl-cnt{margin-left:auto;font-size:.65rem;background:rgba(255,255,255,.06);padding:1px 5px;border-radius:10px;}
.pma-sidebar-foot{padding:8px 10px;border-top:1px solid var(--pma-border);display:flex;flex-direction:column;gap:4px;}
.pma-foot-btn{display:flex;align-items:center;gap:6px;padding:5px 8px;background:transparent;border:1px solid var(--pma-border);border-radius:5px;color:var(--pma-muted);font-size:.72rem;cursor:pointer;text-decoration:none;transition:all .12s;width:100%;}
.pma-foot-btn:hover{border-color:var(--pma-blue);color:var(--pma-blue);}
.pma-foot-btn.red:hover{border-color:var(--pma-red);color:var(--pma-red);}

/* ── Main ── */
.pma-main{flex:1;display:flex;flex-direction:column;overflow:hidden;background:var(--pma-bg);}

/* Breadcrumb */
.pma-breadcrumb{background:var(--pma-header);border-bottom:1px solid var(--pma-border);padding:9px 16px;display:flex;align-items:center;gap:6px;font-size:.78rem;}
.pma-breadcrumb a{color:var(--pma-blue);text-decoration:none;}.pma-breadcrumb a:hover{text-decoration:underline;}
.pma-breadcrumb .sep{color:var(--pma-muted);}
.pma-breadcrumb .cur{color:var(--pma-text);font-weight:600;}
.pma-breadcrumb .server-info{margin-left:auto;font-size:.68rem;color:var(--pma-muted);}

/* Tab nav */
.pma-tabs{display:flex;background:var(--pma-header);border-bottom:1px solid var(--pma-border);padding:0 12px;gap:2px;overflow-x:auto;flex-shrink:0;}
.pma-tabs::-webkit-scrollbar{height:3px;}.pma-tabs::-webkit-scrollbar-thumb{background:var(--pma-border);}
.pma-tab{display:flex;align-items:center;gap:5px;padding:8px 12px;cursor:pointer;color:var(--pma-muted);font-size:.75rem;border-bottom:2px solid transparent;white-space:nowrap;transition:all .12s;background:none;border-top:none;border-left:none;border-right:none;}
.pma-tab:hover{color:var(--pma-text);}
.pma-tab.active{color:var(--pma-blue);border-bottom-color:var(--pma-blue);}
.pma-tab i{font-size:.7rem;}

/* Content */
.pma-content{flex:1;overflow:hidden;position:relative;}
.pma-panel{display:none;height:100%;overflow:auto;padding:14px;}
.pma-panel.active{display:flex;flex-direction:column;gap:10px;}
.pma-panel::-webkit-scrollbar{width:6px;height:6px;}.pma-panel::-webkit-scrollbar-thumb{background:var(--pma-border);border-radius:3px;}

/* ── Structure table (phpMyAdmin style) ── */
.pma-struct-wrap{border:1px solid var(--pma-border);border-radius:8px;overflow:hidden;}
.pma-struct-header{background:var(--pma-header);padding:8px 14px;border-bottom:1px solid var(--pma-border);display:flex;align-items:center;justify-content:space-between;}
.pma-struct-title{font-size:.8rem;font-weight:700;color:var(--pma-text);}
.pma-tbl{width:100%;border-collapse:collapse;font-size:.75rem;}
.pma-tbl th{background:var(--pma-header);color:var(--pma-muted);padding:7px 10px;text-align:left;border-bottom:1px solid var(--pma-border);font-size:.68rem;text-transform:uppercase;letter-spacing:.04em;white-space:nowrap;}
.pma-tbl td{padding:6px 10px;border-bottom:1px solid rgba(45,49,57,.5);vertical-align:middle;white-space:nowrap;}
.pma-tbl tr:hover td{background:rgba(255,255,255,.02);}
.pma-tbl tr.sel td{background:rgba(78,157,224,.06);}
.pma-tbl .chk{width:28px;text-align:center;}
.pma-tbl input[type=checkbox]{cursor:pointer;accent-color:var(--pma-blue);}
.pma-tbl .tbl-name{font-weight:600;color:var(--pma-text);}
.pma-tbl .tbl-name a{color:var(--pma-blue);text-decoration:none;}.pma-tbl .tbl-name a:hover{text-decoration:underline;}

/* Action links */
.act-links{display:flex;gap:4px;flex-wrap:nowrap;}
.act-link{display:inline-flex;align-items:center;gap:3px;padding:2px 7px;border-radius:3px;font-size:.7rem;cursor:pointer;border:1px solid;text-decoration:none;white-space:nowrap;transition:all .1s;}
.act-link.browse{color:#4e9de0;border-color:rgba(78,157,224,.35);}.act-link.browse:hover{background:rgba(78,157,224,.15);}
.act-link.struct{color:#9b59b6;border-color:rgba(155,89,182,.35);}.act-link.struct:hover{background:rgba(155,89,182,.15);}
.act-link.search{color:#5cb85c;border-color:rgba(92,184,92,.35);}.act-link.search:hover{background:rgba(92,184,92,.15);}
.act-link.insert{color:#f0ad4e;border-color:rgba(240,173,78,.35);}.act-link.insert:hover{background:rgba(240,173,78,.15);}
.act-link.empty{color:#e67e22;border-color:rgba(230,126,34,.35);}.act-link.empty:hover{background:rgba(230,126,34,.15);}
.act-link.drop{color:#d9534f;border-color:rgba(217,83,79,.35);}.act-link.drop:hover{background:rgba(217,83,79,.15);}
.act-link.export{color:#1abc9c;border-color:rgba(26,188,156,.35);}.act-link.export:hover{background:rgba(26,188,156,.15);}

/* Badges */
.badge{display:inline-block;padding:1px 6px;border-radius:3px;font-size:.65rem;font-weight:700;text-transform:uppercase;}
.badge-pri{background:rgba(240,173,78,.2);color:#f0ad4e;}
.badge-idx{background:rgba(78,157,224,.2);color:#4e9de0;}
.badge-uni{background:rgba(92,184,92,.2);color:#5cb85c;}
.badge-null{color:var(--pma-muted);font-style:italic;}
.type-tag{font-family:'Cascadia Code','Consolas',monospace;font-size:.72rem;color:#79c0ff;}

/* Foot actions */
.pma-foot-actions{display:flex;align-items:center;gap:10px;padding:8px 0;flex-wrap:wrap;}
.pma-select-all{display:flex;align-items:center;gap:8px;font-size:.75rem;color:var(--pma-muted);}
.pma-with-sel{padding:4px 8px;background:var(--pma-input);border:1px solid var(--pma-border);border-radius:4px;color:var(--pma-text);font-size:.73rem;cursor:pointer;outline:none;}
.pma-btn{display:inline-flex;align-items:center;gap:5px;padding:5px 12px;border-radius:5px;font-size:.75rem;font-weight:600;cursor:pointer;border:1px solid;transition:all .12s;white-space:nowrap;}
.pma-btn.blue{background:rgba(78,157,224,.15);border-color:var(--pma-blue);color:var(--pma-blue);}.pma-btn.blue:hover{background:var(--pma-blue);color:#000;}
.pma-btn.green{background:rgba(92,184,92,.15);border-color:var(--pma-green);color:var(--pma-green);}.pma-btn.green:hover{background:var(--pma-green);color:#000;}
.pma-btn.red{background:rgba(217,83,79,.15);border-color:var(--pma-red);color:var(--pma-red);}.pma-btn.red:hover{background:var(--pma-red);color:#fff;}
.pma-btn.orange{background:rgba(240,173,78,.15);border-color:var(--pma-orange);color:var(--pma-orange);}.pma-btn.orange:hover{background:var(--pma-orange);color:#000;}
.pma-btn.ghost{background:transparent;border-color:var(--pma-border);color:var(--pma-muted);}.pma-btn.ghost:hover{border-color:var(--pma-blue);color:var(--pma-blue);}
.pma-btn:disabled{opacity:.4;cursor:not-allowed;}

/* Create table */
.pma-create-table{background:var(--pma-row);border:1px solid var(--pma-border);border-radius:8px;padding:14px;}
.pma-create-table h4{font-size:.82rem;margin-bottom:10px;color:var(--pma-text);}
.pma-row{display:flex;gap:8px;align-items:center;flex-wrap:wrap;}
.pma-field{display:flex;flex-direction:column;gap:4px;}
.pma-field label{font-size:.67rem;text-transform:uppercase;letter-spacing:.04em;color:var(--pma-muted);}
.pma-input{background:var(--pma-input);border:1px solid var(--pma-border);border-radius:5px;color:var(--pma-text);padding:5px 9px;font-size:.78rem;outline:none;}
.pma-input:focus{border-color:var(--pma-blue);}
.pma-select{background:var(--pma-input);border:1px solid var(--pma-border);border-radius:5px;color:var(--pma-text);padding:5px 9px;font-size:.78rem;outline:none;cursor:pointer;}

/* Browse data */
.pma-data-wrap{border:1px solid var(--pma-border);border-radius:8px;overflow:auto;flex:1;}
.pma-data-tbl{width:100%;border-collapse:collapse;font-size:.75rem;white-space:nowrap;}
.pma-data-tbl th{position:sticky;top:0;z-index:2;background:var(--pma-header);color:var(--pma-muted);padding:7px 10px;text-align:left;border-bottom:1px solid var(--pma-border);font-size:.69rem;text-transform:uppercase;letter-spacing:.03em;}
.pma-data-tbl td{padding:5px 10px;border-bottom:1px solid rgba(45,49,57,.4);max-width:200px;overflow:hidden;text-overflow:ellipsis;}
.pma-data-tbl tr:nth-child(even) td{background:rgba(255,255,255,.015);}
.pma-data-tbl tr:hover td{background:rgba(78,157,224,.05);}
.pma-null{color:var(--pma-muted);font-style:italic;font-size:.7rem;}
.pma-row-acts{display:flex;gap:3px;}
.pma-row-act{padding:2px 6px;border-radius:3px;font-size:.68rem;border:1px solid;cursor:pointer;background:transparent;transition:all .1s;}
.pma-row-act.edit{color:var(--pma-orange);border-color:rgba(240,173,78,.3);}.pma-row-act.edit:hover{background:rgba(240,173,78,.15);}
.pma-row-act.del{color:var(--pma-red);border-color:rgba(217,83,79,.3);}.pma-row-act.del:hover{background:rgba(217,83,79,.15);}

/* Pagination */
.pma-pager{display:flex;align-items:center;gap:5px;flex-wrap:wrap;font-size:.75rem;}
.pma-pg{padding:3px 8px;background:var(--pma-input);border:1px solid var(--pma-border);border-radius:4px;color:var(--pma-text);cursor:pointer;transition:all .1s;}
.pma-pg:hover{border-color:var(--pma-blue);color:var(--pma-blue);}
.pma-pg.active{background:var(--pma-blue);border-color:var(--pma-blue);color:#000;font-weight:700;}
.pma-pg:disabled{opacity:.4;cursor:not-allowed;}
.pma-pg-info{color:var(--pma-muted);margin-left:4px;}

/* SQL editor */
.pma-sql-editor{width:100%;min-height:120px;resize:vertical;background:var(--pma-input);border:1px solid var(--pma-border);border-radius:6px;color:var(--pma-text);font-family:'Cascadia Code','Consolas',monospace;font-size:.8rem;padding:10px;outline:none;line-height:1.6;}
.pma-sql-editor:focus{border-color:var(--pma-blue);}

/* Messages */
.pma-msg{padding:8px 12px;border-radius:6px;font-size:.78rem;display:flex;align-items:flex-start;gap:7px;line-height:1.5;}
.pma-msg.ok{background:rgba(92,184,92,.1);border:1px solid rgba(92,184,92,.3);color:#5cb85c;}
.pma-msg.err{background:rgba(217,83,79,.1);border:1px solid rgba(217,83,79,.3);color:#e57373;}
.pma-msg.info{background:rgba(78,157,224,.08);border:1px solid rgba(78,157,224,.25);color:#4e9de0;}

/* Insert form */
.pma-insert-grid{display:grid;grid-template-columns:180px 1fr;gap:0;border:1px solid var(--pma-border);border-radius:6px;overflow:hidden;}
.pma-insert-row{display:contents;}
.pma-insert-row .col-name{background:var(--pma-header);padding:7px 12px;border-bottom:1px solid var(--pma-border);font-size:.75rem;color:var(--pma-muted);display:flex;align-items:center;gap:5px;}
.pma-insert-row .col-val{background:var(--pma-row);padding:5px 8px;border-bottom:1px solid var(--pma-border);}
.pma-insert-row .col-val input,.pma-insert-row .col-val textarea{width:100%;background:var(--pma-input);border:1px solid var(--pma-border);border-radius:4px;color:var(--pma-text);padding:4px 8px;font-size:.78rem;outline:none;}
.pma-insert-row .col-val input:focus,.pma-insert-row .col-val textarea:focus{border-color:var(--pma-blue);}

/* Import */
.pma-drop-zone{border:2px dashed var(--pma-border);border-radius:8px;padding:36px;text-align:center;cursor:pointer;color:var(--pma-muted);transition:all .2s;}
.pma-drop-zone:hover,.pma-drop-zone.drag{border-color:var(--pma-blue);color:var(--pma-blue);}
.pma-drop-zone i{font-size:2rem;margin-bottom:10px;display:block;}

/* Loader */
.pma-loader{display:none;position:absolute;inset:0;background:rgba(26,29,35,.8);z-index:20;align-items:center;justify-content:center;gap:8px;font-size:.83rem;color:var(--pma-blue);}
.pma-loader.show{display:flex;}
@keyframes pma-spin{to{transform:rotate(360deg);}}
.pma-spin{animation:pma-spin .7s linear infinite;}

/* Edit row modal */
.pma-modal-overlay{display:none;position:fixed;inset:0;background:rgba(0,0,0,.65);z-index:1000;align-items:center;justify-content:center;}
.pma-modal-overlay.show{display:flex;}
.pma-modal{background:var(--pma-header);border:1px solid var(--pma-border);border-radius:10px;width:540px;max-width:95vw;max-height:85vh;display:flex;flex-direction:column;box-shadow:0 24px 60px rgba(0,0,0,.5);}
.pma-modal-head{padding:14px 18px;border-bottom:1px solid var(--pma-border);display:flex;align-items:center;justify-content:space-between;}
.pma-modal-head h3{font-size:.9rem;}
.pma-modal-close{background:none;border:none;color:var(--pma-muted);font-size:1.1rem;cursor:pointer;padding:2px 6px;}
.pma-modal-body{flex:1;overflow-y:auto;padding:14px 18px;}
.pma-modal-foot{padding:12px 18px;border-top:1px solid var(--pma-border);display:flex;justify-content:flex-end;gap:8px;}

/* Connect card */
.pma-connect-wrap{display:flex;align-items:center;justify-content:center;min-height:100%;padding:30px;}
.pma-connect-card{background:var(--pma-header);border:1px solid var(--pma-border);border-radius:12px;padding:32px 36px;width:100%;max-width:420px;}
.pma-connect-card h2{font-size:1rem;margin-bottom:16px;display:flex;align-items:center;gap:8px;}
.pma-connect-err{background:rgba(217,83,79,.1);border:1px solid rgba(217,83,79,.3);color:#e57373;padding:9px 12px;border-radius:6px;font-size:.78rem;margin-bottom:12px;line-height:1.6;}
.db-input-sel{width:100%;background:var(--pma-input);border:1px solid var(--pma-border);border-radius:6px;color:var(--pma-text);padding:7px 10px;font-size:.8rem;outline:none;}
.db-input-sel:focus{border-color:var(--pma-blue);}

/* DB operations */
.ops-grid{display:grid;grid-template-columns:repeat(auto-fill,minmax(200px,1fr));gap:10px;}
.ops-card{background:var(--pma-row);border:1px solid var(--pma-border);border-radius:8px;padding:14px;}
.ops-card h4{font-size:.78rem;font-weight:700;margin-bottom:10px;color:var(--pma-muted);text-transform:uppercase;letter-spacing:.04em;}

/* Search */
.pma-search-form{background:var(--pma-row);border:1px solid var(--pma-border);border-radius:8px;padding:14px;}
</style>

<div class="pma-wrap">
{{-- ════ SIDEBAR ════ --}}
<div class="pma-sidebar">
    <div class="pma-sidebar-logo">
        <i class="fas fa-database logo-icon"></i>
        <div>
            <div class="logo-text">MySQL Manager</div>
            <div class="logo-sub">{{ $prefix }}* databases only</div>
        </div>
    </div>
    <div class="pma-db-label">Database</div>
    <div class="pma-db-item"><i class="fas fa-database"></i> {{ $db }}</div>

    @if($connected)
    <div class="pma-search-box">
        <input type="text" id="sideSearch" placeholder="Filter tables…" oninput="filterSide(this.value)">
    </div>
    <div class="pma-tbl-list" id="sideList">
        @forelse($tables as $t)
        <div class="pma-tbl-item" data-table="{{ $t['Name'] }}" onclick="selectTable('{{ $t['Name'] }}')">
            <i class="fas fa-table"></i>
            <span style="overflow:hidden;text-overflow:ellipsis;white-space:nowrap;">{{ $t['Name'] }}</span>
            <span class="pma-tbl-cnt">{{ number_format($t['Rows'] ?? 0) }}</span>
        </div>
        @empty
        <div style="padding:12px 14px;color:var(--pma-muted);font-size:.74rem;">No tables</div>
        @endforelse
    </div>
    @endif

    <div class="pma-sidebar-foot">
        @if($connected)
        <a href="{{ $urlBase }}/export?type=full" class="pma-foot-btn" onclick="return exportDb(event)">
            <i class="fas fa-download"></i> Export DB
        </a>
        <a href="{{ route('mysql.disconnect', $db) }}" class="pma-foot-btn red" onclick="return confirm('Disconnect?')">
            <i class="fas fa-unlink"></i> Disconnect
        </a>
        @endif
        <a href="{{ route('databases') }}" class="pma-foot-btn">
            <i class="fas fa-arrow-left"></i> Databases
        </a>
    </div>
</div>

{{-- ════ MAIN ════ --}}
<div class="pma-main">

@if(!$connected)
{{-- Connect form --}}
<div class="pma-connect-wrap">
    <div class="pma-connect-card">
        <h2><i class="fas fa-plug" style="color:var(--pma-blue);"></i> Connect to Database</h2>

        @if($connectError)
        <div class="pma-connect-err">
            <i class="fas fa-exclamation-circle"></i> {{ $connectError }}
            @if(str_contains($connectError ?? '', '1045') || str_contains($connectError ?? '', 'Access denied'))
            <div style="margin-top:6px;font-size:.72rem;">
                ① Username must be a <strong>DB User</strong> (not the database name)<br>
                ② Verify the password you set when creating the DB user<br>
                ③ Make sure the user is <a href="{{ route('databases') }}" style="color:#93c5fd;">assigned to this database</a>
            </div>
            @endif
        </div>
        @endif

        <form method="POST" action="{{ route('mysql.connect') }}">
            @csrf
            <input type="hidden" name="db" value="{{ $db }}">
            <div class="pma-field" style="margin-bottom:12px;">
                <label>DB Username</label>
                @if(!empty($dbUsers))
                <select name="user" class="db-input-sel" required>
                    <option value="">— Select DB User —</option>
                    @foreach($dbUsers as $u)
                    <option value="{{ $u }}" {{ old('user')===$u?'selected':'' }}>{{ $u }}</option>
                    @endforeach
                </select>
                <span style="font-size:.7rem;color:var(--pma-muted);margin-top:4px;">Must be assigned to <strong>{{ $db }}</strong></span>
                @else
                <input name="user" value="{{ old('user', $prefix) }}" class="pma-input" style="width:100%" placeholder="{{ $prefix }}myuser" required>
                <span style="font-size:.7rem;color:#f0ad4e;margin-top:4px;"><i class="fas fa-exclamation-triangle"></i>
                    No DB users found. <a href="{{ route('databases') }}" style="color:var(--pma-blue);">Create one first →</a></span>
                @endif
            </div>
            <div class="pma-field" style="margin-bottom:16px;">
                <label>Password</label>
                <input name="pass" type="password" class="pma-input" style="width:100%" placeholder="DB user password" required>
            </div>
            <button type="submit" class="pma-btn blue" style="width:100%;justify-content:center;padding:9px;" id="connectBtn">
                <i class="fas fa-plug"></i> Connect &amp; Open Manager
            </button>
        </form>
    </div>
</div>

@else
{{-- ══ Connected: full manager ══ --}}

{{-- Breadcrumb --}}
<div class="pma-breadcrumb">
    <i class="fas fa-server" style="color:var(--pma-muted);font-size:.7rem;"></i>
    <span style="color:var(--pma-muted);">Server</span>
    <span class="sep">›</span>
    <a href="#" onclick="selectDbTab('structure');return false;">{{ $db }}</a>
    <span class="sep" id="bc-sep" style="display:none">›</span>
    <span class="cur" id="bc-table" style="display:none"></span>
    <span class="server-info"><i class="fas fa-lock" style="color:var(--pma-green);"></i> Secure Proxy</span>
</div>

{{-- DB-level tabs --}}
<div class="pma-tabs" id="db-tabs">
    <button class="pma-tab active" id="dbtab-structure" onclick="selectDbTab('structure')"><i class="fas fa-th-list"></i> Structure</button>
    <button class="pma-tab" id="dbtab-sql" onclick="selectDbTab('sql')"><i class="fas fa-terminal"></i> SQL</button>
    <button class="pma-tab" id="dbtab-search" onclick="selectDbTab('search')"><i class="fas fa-search"></i> Search</button>
    <button class="pma-tab" id="dbtab-import" onclick="selectDbTab('import')"><i class="fas fa-file-import"></i> Import</button>
    <button class="pma-tab" id="dbtab-operations" onclick="selectDbTab('operations')"><i class="fas fa-cogs"></i> Operations</button>
</div>

{{-- Table-level tabs (shown when table selected) --}}
<div class="pma-tabs" id="tbl-tabs" style="display:none;">
    <button class="pma-tab active" id="tbltab-browse" onclick="selectTblTab('browse')"><i class="fas fa-table"></i> Browse</button>
    <button class="pma-tab" id="tbltab-structure" onclick="selectTblTab('structure')"><i class="fas fa-columns"></i> Structure</button>
    <button class="pma-tab" id="tbltab-search" onclick="selectTblTab('search')"><i class="fas fa-search"></i> Search</button>
    <button class="pma-tab" id="tbltab-insert" onclick="selectTblTab('insert')"><i class="fas fa-plus"></i> Insert</button>
    <button class="pma-tab" id="tbltab-export" onclick="selectTblTab('export')"><i class="fas fa-download"></i> Export</button>
</div>

<div class="pma-content">
    <div class="pma-loader" id="pmaLoader"><i class="fas fa-circle-notch pma-spin"></i> Loading…</div>

    {{-- DB: Structure --}}
    <div class="pma-panel active" id="dbpanel-structure">
        <div class="pma-struct-wrap">
            <div class="pma-struct-header">
                <span class="pma-struct-title"><i class="fas fa-database" style="color:var(--pma-blue);margin-right:6px;"></i>Tables in <code>{{ $db }}</code></span>
                <span style="font-size:.72rem;color:var(--pma-muted);">{{ count($tables) }} table(s)</span>
            </div>
            <table class="pma-tbl" id="mainStructTable">
                <thead><tr>
                    <th class="chk"><input type="checkbox" id="checkAll" onchange="toggleAll(this)"></th>
                    <th>Table</th>
                    <th>Action</th>
                    <th>Rows</th>
                    <th>Type</th>
                    <th>Collation</th>
                    <th>Size</th>
                </tr></thead>
                <tbody>
                @forelse($tables as $t)
                <tr id="trow-{{ md5($t['Name']) }}">
                    <td class="chk"><input type="checkbox" class="row-chk" value="{{ $t['Name'] }}"></td>
                    <td class="tbl-name">
                        <a href="#" onclick="selectTable('{{ $t['Name'] }}');return false;">{{ $t['Name'] }}</a>
                    </td>
                    <td>
                        <div class="act-links">
                            <a class="act-link browse" href="#" onclick="selectTable('{{ $t['Name'] }}');return false;"><i class="fas fa-eye"></i> Browse</a>
                            <a class="act-link struct" href="#" onclick="selectTable('{{ $t['Name'] }}');selectTblTab('structure');return false;"><i class="fas fa-columns"></i> Structure</a>
                            <a class="act-link search" href="#" onclick="selectTable('{{ $t['Name'] }}');selectTblTab('search');return false;"><i class="fas fa-search"></i> Search</a>
                            <a class="act-link insert" href="#" onclick="selectTable('{{ $t['Name'] }}');selectTblTab('insert');return false;"><i class="fas fa-plus"></i> Insert</a>
                            <a class="act-link empty" href="#" onclick="emptyTable('{{ $t['Name'] }}','{{ md5($t['Name']) }}');return false;"><i class="fas fa-eraser"></i> Empty</a>
                            <a class="act-link drop" href="#" onclick="dropTable('{{ $t['Name'] }}','{{ md5($t['Name']) }}');return false;"><i class="fas fa-trash"></i> Drop</a>
                        </div>
                    </td>
                    <td>{{ number_format($t['Rows'] ?? 0) }}</td>
                    <td><span class="badge badge-idx">{{ $t['Engine'] ?? 'InnoDB' }}</span></td>
                    <td style="font-size:.7rem;color:var(--pma-muted);">{{ $t['Collation'] ?? '' }}</td>
                    <td style="font-size:.72rem;">{{ $t['Data_length'] ? number_format(($t['Data_length'] + ($t['Index_length']??0))/1024, 1).' KiB' : '-' }}</td>
                </tr>
                @empty
                <tr><td colspan="7" style="padding:24px;text-align:center;color:var(--pma-muted);">
                    <i class="fas fa-inbox" style="font-size:1.5rem;display:block;margin-bottom:8px;opacity:.3;"></i>No tables found
                </td></tr>
                @endforelse
                </tbody>
                @if(count($tables)>0)
                <tfoot><tr>
                    <td colspan="2" style="padding:7px 10px;font-size:.73rem;color:var(--pma-muted);">
                        Sum: {{ count($tables) }} table(s)
                    </td>
                    <td colspan="5" style="padding:7px 10px;font-size:.72rem;color:var(--pma-muted);">
                        {{ number_format(collect($tables)->sum(fn($t)=>($t['Data_length']??0)+($t['Index_length']??0))/1024, 1) }} KiB total
                    </td>
                </tr></tfoot>
                @endif
            </table>
        </div>

        {{-- Foot actions --}}
        <div class="pma-foot-actions">
            <div class="pma-select-all">
                <a href="#" onclick="document.getElementById('checkAll').click();return false;" style="color:var(--pma-blue);font-size:.73rem;">Check all</a>
                <span style="color:var(--pma-muted);">/</span>
                <a href="#" onclick="uncheckAll();return false;" style="color:var(--pma-blue);font-size:.73rem;">Uncheck all</a>
                <span>With selected:</span>
                <select class="pma-with-sel" id="withSelected" onchange="doWithSelected(this.value)">
                    <option value="">— Choose —</option>
                    <option value="drop">Drop</option>
                    <option value="empty">Empty</option>
                    <option value="export">Export (Structure+Data)</option>
                </select>
            </div>
        </div>

        {{-- Create new table --}}
        <div class="pma-create-table">
            <h4><i class="fas fa-plus-circle" style="color:var(--pma-green);margin-right:6px;"></i>Create new table</h4>
            <div class="pma-row" style="gap:12px;align-items:flex-end;">
                <div class="pma-field">
                    <label>Table Name</label>
                    <input type="text" class="pma-input" id="newTblName" placeholder="my_table" style="width:180px;">
                </div>
                <div class="pma-field">
                    <label>Columns</label>
                    <input type="number" class="pma-input" id="newTblCols" value="4" min="1" max="30" style="width:80px;">
                </div>
                <button class="pma-btn green" onclick="openCreateTable()"><i class="fas fa-plus"></i> Create</button>
            </div>
        </div>
    </div>

    {{-- DB: SQL --}}
    <div class="pma-panel" id="dbpanel-sql">
        <div id="sqlMsg"></div>
        <textarea class="pma-sql-editor" id="sqlEditor" placeholder="-- Write your SQL&#10;SELECT * FROM `table` LIMIT 25;"></textarea>
        <div style="display:flex;gap:8px;align-items:center;">
            <button class="pma-btn blue" onclick="runQuery()"><i class="fas fa-play"></i> Go</button>
            <button class="pma-btn ghost" onclick="document.getElementById('sqlEditor').value=''"><i class="fas fa-times"></i> Clear</button>
            <span style="font-size:.7rem;color:var(--pma-muted);">Ctrl+Enter to run</span>
        </div>
        <div class="pma-data-wrap" id="sqlResWrap" style="display:none;max-height:340px;">
            <table class="pma-data-tbl"><thead id="sqlHead"></thead><tbody id="sqlBody"></tbody></table>
        </div>
    </div>

    {{-- DB: Search --}}
    <div class="pma-panel" id="dbpanel-search">
        <div class="pma-search-form">
            <h4 style="font-size:.82rem;margin-bottom:12px;"><i class="fas fa-search" style="color:var(--pma-blue);margin-right:6px;"></i>Search in database</h4>
            <div class="pma-row" style="gap:10px;align-items:flex-end;flex-wrap:wrap;">
                <div class="pma-field" style="flex:1;min-width:160px;">
                    <label>Search for</label>
                    <input type="text" class="pma-input" id="dbSearchWord" placeholder="keyword" style="width:100%;">
                </div>
                <div class="pma-field">
                    <label>Table</label>
                    <select class="pma-select" id="dbSearchTable">
                        <option value="">All tables</option>
                        @foreach($tables as $t)
                        <option value="{{ $t['Name'] }}">{{ $t['Name'] }}</option>
                        @endforeach
                    </select>
                </div>
                <button class="pma-btn blue" onclick="doDbSearch()"><i class="fas fa-search"></i> Search</button>
            </div>
        </div>
        <div id="dbSearchResults"></div>
    </div>

    {{-- DB: Import --}}
    <div class="pma-panel" id="dbpanel-import">
        <div id="importMsg"></div>
        <div class="pma-msg info"><i class="fas fa-info-circle"></i> Import a <code>.sql</code> file into <strong>{{ $db }}</strong>. Max 100 MB.</div>
        <div class="pma-drop-zone" id="dropZone" onclick="document.getElementById('sqlFile').click()"
             ondragover="event.preventDefault();this.classList.add('drag')"
             ondragleave="this.classList.remove('drag')"
             ondrop="handleDrop(event)">
            <i class="fas fa-file-upload"></i>
            <strong>Click or drag &amp; drop</strong> your .sql file here
        </div>
        <input type="file" id="sqlFile" style="display:none" accept=".sql,.txt" onchange="startImport(this.files[0])">
        <div id="importProgress" style="display:none;margin-top:10px;">
            <div style="background:var(--pma-input);border-radius:4px;overflow:hidden;height:5px;">
                <div id="importBar" style="height:100%;width:0%;background:var(--pma-green);transition:width .3s;"></div>
            </div>
            <div id="importLabel" style="font-size:.73rem;color:var(--pma-muted);margin-top:4px;"></div>
        </div>
    </div>

    {{-- DB: Operations --}}
    <div class="pma-panel" id="dbpanel-operations">
        <div class="ops-grid">
            <div class="ops-card">
                <h4><i class="fas fa-tools" style="color:var(--pma-blue);margin-right:5px;"></i>Table Maintenance</h4>
                <div style="display:flex;flex-direction:column;gap:6px;">
                    <button class="pma-btn blue" onclick="runOnAllTables('OPTIMIZE TABLE')"><i class="fas fa-magic"></i> Optimize all tables</button>
                    <button class="pma-btn ghost" onclick="runOnAllTables('ANALYZE TABLE')"><i class="fas fa-chart-bar"></i> Analyze all tables</button>
                    <button class="pma-btn ghost" onclick="runOnAllTables('CHECK TABLE')"><i class="fas fa-check"></i> Check all tables</button>
                </div>
            </div>
            <div class="ops-card">
                <h4><i class="fas fa-info-circle" style="color:var(--pma-blue);margin-right:5px;"></i>DB Status</h4>
                <button class="pma-btn blue" onclick="showDbStatus()"><i class="fas fa-list"></i> Show Variables</button>
            </div>
        </div>
        <div id="opsResult" style="margin-top:10px;"></div>
    </div>

    {{-- TABLE: Browse --}}
    <div class="pma-panel" id="tblpanel-browse">
        <div style="display:flex;gap:8px;align-items:center;flex-wrap:wrap;">
            <input type="text" class="pma-input" id="browseSearch" placeholder="Search all columns…" style="flex:1;min-width:120px;" onkeydown="if(event.key==='Enter')loadBrowse(1)">
            <button class="pma-btn blue" onclick="loadBrowse(1)"><i class="fas fa-search"></i> Search</button>
            <button class="pma-btn ghost" onclick="document.getElementById('browseSearch').value='';loadBrowse(1)">Clear</button>
        </div>
        <div class="pma-data-wrap">
            <table class="pma-data-tbl">
                <thead id="browseHead"></thead>
                <tbody id="browseBody"><tr><td style="padding:24px;text-align:center;color:var(--pma-muted);">Select a table to browse</td></tr></tbody>
            </table>
        </div>
        <div class="pma-pager" id="browsePager"></div>
    </div>

    {{-- TABLE: Structure --}}
    <div class="pma-panel" id="tblpanel-structure">
        <div id="tblStructContent">
            <div style="padding:24px;text-align:center;color:var(--pma-muted);">Select a table</div>
        </div>
    </div>

    {{-- TABLE: Search --}}
    <div class="pma-panel" id="tblpanel-search">
        <div class="pma-search-form">
            <h4 style="font-size:.82rem;margin-bottom:12px;"><i class="fas fa-search" style="color:var(--pma-blue);margin-right:6px;"></i>Search in table: <span id="tblSearchName" style="color:var(--pma-blue);"></span></h4>
            <div class="pma-row" style="gap:10px;align-items:flex-end;">
                <div class="pma-field" style="flex:1;">
                    <label>Keyword</label>
                    <input type="text" class="pma-input" id="tblSearchWord" placeholder="search term…" style="width:100%;">
                </div>
                <button class="pma-btn blue" onclick="doTblSearch()"><i class="fas fa-search"></i> Go</button>
            </div>
        </div>
        <div id="tblSearchResults" style="margin-top:10px;"></div>
    </div>

    {{-- TABLE: Insert --}}
    <div class="pma-panel" id="tblpanel-insert">
        <div id="insertMsg"></div>
        <div id="insertFormWrap">
            <div style="padding:24px;text-align:center;color:var(--pma-muted);">Select a table to insert data</div>
        </div>
        <div id="insertBtns" style="display:none;margin-top:10px;display:none;">
            <button class="pma-btn green" onclick="submitInsert()"><i class="fas fa-save"></i> Insert Row</button>
        </div>
    </div>

    {{-- TABLE: Export --}}
    <div class="pma-panel" id="tblpanel-export">
        <div style="font-size:.83rem;margin-bottom:14px;color:var(--pma-muted);">Export table: <strong id="exportTblName" style="color:var(--pma-text);"></strong></div>
        <div style="display:flex;gap:10px;flex-wrap:wrap;">
            <button class="pma-btn blue"   onclick="doExportTable('full')"><i class="fas fa-download"></i> Structure + Data</button>
            <button class="pma-btn ghost"  onclick="doExportTable('structure')"><i class="fas fa-download"></i> Structure Only</button>
            <button class="pma-btn ghost"  onclick="doExportTable('data')"><i class="fas fa-download"></i> Data Only</button>
        </div>
    </div>

</div>{{-- /.pma-content --}}
@endif
</div>{{-- /.pma-main --}}
</div>{{-- /.pma-wrap --}}

{{-- Edit Row Modal --}}
<div class="pma-modal-overlay" id="editModal">
    <div class="pma-modal">
        <div class="pma-modal-head">
            <h3><i class="fas fa-edit" style="color:var(--pma-orange);margin-right:6px;"></i>Edit Row</h3>
            <button class="pma-modal-close" onclick="closeEditModal()"><i class="fas fa-times"></i></button>
        </div>
        <div class="pma-modal-body" id="editModalBody"></div>
        <div class="pma-modal-foot">
            <button class="pma-btn ghost" onclick="closeEditModal()">Cancel</button>
            <button class="pma-btn orange" onclick="submitEdit()"><i class="fas fa-save"></i> Save</button>
        </div>
    </div>
</div>

{{-- Create Table Modal --}}
<div class="pma-modal-overlay" id="createTblModal">
    <div class="pma-modal" style="width:700px;">
        <div class="pma-modal-head">
            <h3><i class="fas fa-plus-circle" style="color:var(--pma-green);margin-right:6px;"></i>Create Table: <span id="newTblModalName" style="color:var(--pma-green);"></span></h3>
            <button class="pma-modal-close" onclick="document.getElementById('createTblModal').classList.remove('show')"><i class="fas fa-times"></i></button>
        </div>
        <div class="pma-modal-body" id="createTblBody"></div>
        <div class="pma-modal-foot">
            <button class="pma-btn ghost" onclick="document.getElementById('createTblModal').classList.remove('show')">Cancel</button>
            <button class="pma-btn green" onclick="submitCreateTable()"><i class="fas fa-check"></i> Create Table</button>
        </div>
    </div>
</div>

<script>
const CSRF = '{{ $csrfToken }}';
const DB   = '{{ $db }}';
const URL_BROWSE    = '{{ $urlBase }}/browse/__T__';
const URL_STRUCT    = '{{ $urlBase }}/structure/__T__';
const URL_QUERY     = '{{ $urlBase }}/query';
const URL_IMPORT    = '{{ $urlBase }}/import';
const URL_EXPORT    = '{{ $urlBase }}/export';
const URL_DROP      = '{{ $urlBase }}/table/__T__';
const URL_TRUNCATE  = '{{ $urlBase }}/truncate/__T__';
const URL_COLUMNS   = '{{ $urlBase }}/columns/__T__';
const URL_INSERT    = '{{ $urlBase }}/insert/__T__';
const URL_UPDATE    = '{{ $urlBase }}/update/__T__';
const URL_ROW_DEL   = '{{ $urlBase }}/row/__T__';
const URL_CREATE_TBL= '{{ $urlBase }}/create-table';
const URL_EXP_TBL   = '{{ $urlBase }}/export-table/__T__';

let curTable = null, curPage = 1, curPk = '', editRowData = {};

// ── Tab switching ───────────────────────────────────────────
function selectDbTab(name) {
    curTable = null;
    document.querySelectorAll('#db-tabs .pma-tab').forEach(b => b.classList.remove('active'));
    document.querySelectorAll('[id^="dbpanel-"]').forEach(p => p.classList.remove('active'));
    document.getElementById('dbtab-'+name).classList.add('active');
    document.getElementById('dbpanel-'+name).classList.add('active');
    document.getElementById('tbl-tabs').style.display = 'none';
    document.getElementById('bc-sep').style.display = 'none';
    document.getElementById('bc-table').style.display = 'none';
    document.querySelectorAll('[id^="tblpanel-"]').forEach(p => p.classList.remove('active'));
    document.querySelectorAll('.pma-tbl-item').forEach(i => i.classList.remove('active'));
}

function selectTblTab(name) {
    document.querySelectorAll('#tbl-tabs .pma-tab').forEach(b => b.classList.remove('active'));
    document.querySelectorAll('[id^="tblpanel-"]').forEach(p => p.classList.remove('active'));
    document.querySelectorAll('[id^="dbpanel-"]').forEach(p => p.classList.remove('active'));
    document.getElementById('tbltab-'+name).classList.add('active');
    document.getElementById('tblpanel-'+name).classList.add('active');

    if (name === 'browse') loadBrowse(1);
    else if (name === 'structure') loadTblStructure();
    else if (name === 'insert') loadInsertForm();
    else if (name === 'search') { document.getElementById('tblSearchName').textContent = curTable; }
    else if (name === 'export') { document.getElementById('exportTblName').textContent = curTable; }
}

function selectTable(name) {
    curTable = name;
    document.querySelectorAll('.pma-tbl-item').forEach(el => el.classList.toggle('active', el.dataset.table === name));
    document.getElementById('bc-sep').style.display = '';
    document.getElementById('bc-table').textContent = name;
    document.getElementById('bc-table').style.display = '';
    document.getElementById('tbl-tabs').style.display = 'flex';
    document.querySelectorAll('[id^="dbpanel-"]').forEach(p => p.classList.remove('active'));
    selectTblTab('browse');
}

function filterSide(q) {
    q = q.toLowerCase();
    document.querySelectorAll('.pma-tbl-item').forEach(el => {
        el.style.display = el.dataset.table.toLowerCase().includes(q) ? '' : 'none';
    });
}

// ── Loader ──────────────────────────────────────────────────
function loader(v) { document.getElementById('pmaLoader')?.classList.toggle('show', v); }

// ── Browse ──────────────────────────────────────────────────
async function loadBrowse(page) {
    if (!curTable) return;
    curPage = page;
    loader(true);
    const search = document.getElementById('browseSearch')?.value || '';
    const url = URL_BROWSE.replace('__T__', encodeURIComponent(curTable)) + `?page=${page}&search=${encodeURIComponent(search)}`;
    try {
        const d = await apiGet(url);
        if (d.error) { showBrowseErr(d.error); return; }
        curPk = d.pk || '';
        renderBrowse(d);
    } catch(e) { showBrowseErr(e.message); }
    finally { loader(false); }
}

function showBrowseErr(msg) {
    document.getElementById('browseHead').innerHTML = '';
    document.getElementById('browseBody').innerHTML = `<tr><td><div class="pma-msg err"><i class="fas fa-exclamation-circle"></i>${esc(msg)}</div></td></tr>`;
}

function renderBrowse(d) {
    const head = document.getElementById('browseHead');
    head.innerHTML = '<tr><th style="width:70px;">Edit/Del</th>' + d.columns.map(c=>`<th>${esc(c)}</th>`).join('') + '</tr>';
    const body = document.getElementById('browseBody');
    if (!d.rows.length) {
        body.innerHTML = `<tr><td colspan="${d.columns.length+1}" style="padding:20px;text-align:center;color:var(--pma-muted);">Empty table</td></tr>`;
    } else {
        body.innerHTML = d.rows.map((row,i) => {
            const pkVal = curPk ? (row[curPk] ?? '') : '';
            return `<tr>
                <td><div class="pma-row-acts">
                    ${curPk ? `<button class="pma-row-act edit" onclick="openEditRow(${JSON.stringify(row).replace(/"/g,'&quot;')})"><i class="fas fa-pencil-alt"></i></button>` : ''}
                    ${curPk ? `<button class="pma-row-act del" onclick="deleteRow(${JSON.stringify(String(pkVal)).replace(/"/g,'&quot;')})"><i class="fas fa-trash"></i></button>` : ''}
                </div></td>
                ${d.columns.map(c => {
                    const v = row[c];
                    if (v === null) return '<td><span class="pma-null">NULL</span></td>';
                    const s = String(v);
                    return `<td title="${esc(s)}">${esc(s.length>80?s.slice(0,80)+'…':s)}</td>`;
                }).join('')}
            </tr>`;
        }).join('');
    }
    renderPager(d);
}

function renderPager(d) {
    const p = document.getElementById('browsePager');
    if (d.pages <= 1) { p.innerHTML = `<span class="pma-pg-info">${d.total} rows</span>`; return; }
    let h = `<button class="pma-pg" ${d.page<=1?'disabled':''} onclick="loadBrowse(${d.page-1})"><i class="fas fa-chevron-left"></i></button>`;
    const s = Math.max(1,d.page-2), e = Math.min(d.pages,d.page+2);
    if(s>1) h+=`<button class="pma-pg" onclick="loadBrowse(1)">1</button>${s>2?'<span style="color:var(--pma-muted)">…</span>':''}`;
    for(let i=s;i<=e;i++) h+=`<button class="pma-pg ${i===d.page?'active':''}" onclick="loadBrowse(${i})">${i}</button>`;
    if(e<d.pages) h+=`${e<d.pages-1?'<span style="color:var(--pma-muted)">…</span>':''}<button class="pma-pg" onclick="loadBrowse(${d.pages})">${d.pages}</button>`;
    h+=`<button class="pma-pg" ${d.page>=d.pages?'disabled':''} onclick="loadBrowse(${d.page+1})"><i class="fas fa-chevron-right"></i></button>`;
    h+=`<span class="pma-pg-info">Page ${d.page}/${d.pages} — ${d.total} rows</span>`;
    p.innerHTML = h;
}

// ── Table Structure ──────────────────────────────────────────
async function loadTblStructure() {
    if (!curTable) return;
    loader(true);
    const url = URL_STRUCT.replace('__T__', encodeURIComponent(curTable));
    try {
        const d = await apiGet(url);
        if (d.error) { document.getElementById('tblStructContent').innerHTML=`<div class="pma-msg err">${esc(d.error)}</div>`; return; }
        renderTblStruct(d);
    } finally { loader(false); }
}

function renderTblStruct(d) {
    const kb = k => !k?'':k==='PRI'?'<span class="badge badge-pri">PRI</span>':k==='MUL'?'<span class="badge badge-idx">IDX</span>':k==='UNI'?'<span class="badge badge-uni">UNI</span>':'';
    let h = `<div class="pma-struct-wrap">
        <div class="pma-struct-header"><span class="pma-struct-title">Structure of <code>${esc(curTable)}</code></span></div>
        <table class="pma-tbl">
        <thead><tr><th>#</th><th>Name</th><th>Type</th><th>Null</th><th>Key</th><th>Default</th><th>Extra</th></tr></thead>
        <tbody>${d.columns.map((c,i)=>`<tr>
            <td style="color:var(--pma-muted);">${i+1}</td>
            <td><strong>${esc(c.Field)}</strong></td>
            <td><span class="type-tag">${esc(c.Type)}</span></td>
            <td style="color:${c.Null==='YES'?'var(--pma-muted)':'var(--pma-text)'};">${c.Null}</td>
            <td>${kb(c.Key)}</td>
            <td style="color:var(--pma-muted);">${c.Default??'<span class="pma-null">NULL</span>'}</td>
            <td style="color:var(--pma-green);font-size:.72rem;">${esc(c.Extra)}</td>
        </tr>`).join('')}</tbody>
        </table>
    </div>`;
    if (d.create) h += `<div style="margin-top:10px;"><div style="font-size:.7rem;color:var(--pma-muted);margin-bottom:6px;">CREATE TABLE statement</div><pre style="background:var(--pma-input);border:1px solid var(--pma-border);border-radius:6px;padding:12px;font-size:.73rem;color:#79c0ff;overflow-x:auto;white-space:pre;line-height:1.7;">${esc(d.create)}</pre></div>`;
    document.getElementById('tblStructContent').innerHTML = h;
}

// ── SQL ──────────────────────────────────────────────────────
async function runQuery() {
    const sql = document.getElementById('sqlEditor').value.trim();
    if (!sql) return;
    loader(true);
    document.getElementById('sqlMsg').innerHTML='';
    document.getElementById('sqlResWrap').style.display='none';
    try {
        const d = await apiPost(URL_QUERY, {sql});
        if (d.error) { document.getElementById('sqlMsg').innerHTML=`<div class="pma-msg err"><i class="fas fa-exclamation-circle"></i>${esc(d.error)}</div>`; }
        else if (d.type==='exec') { document.getElementById('sqlMsg').innerHTML=`<div class="pma-msg ok"><i class="fas fa-check-circle"></i>OK — ${d.affected} row(s) affected.</div>`; }
        else {
            document.getElementById('sqlHead').innerHTML='<tr>'+d.columns.map(c=>`<th>${esc(c)}</th>`).join('')+'</tr>';
            document.getElementById('sqlBody').innerHTML=d.rows.map(row=>'<tr>'+d.columns.map(c=>{const v=row[c];return v===null?'<td><span class="pma-null">NULL</span></td>':`<td title="${esc(String(v))}">${esc(String(v).slice(0,100))}</td>`;}).join('')+'</tr>').join('');
            document.getElementById('sqlResWrap').style.display='block';
            document.getElementById('sqlMsg').innerHTML=`<div class="pma-msg info"><i class="fas fa-table"></i>${d.count} row(s) returned.</div>`;
        }
    } finally { loader(false); }
}

// ── Insert ───────────────────────────────────────────────────
async function loadInsertForm() {
    if (!curTable) return;
    loader(true);
    const url = URL_COLUMNS.replace('__T__', encodeURIComponent(curTable));
    try {
        const d = await apiGet(url);
        if (d.error) { document.getElementById('insertFormWrap').innerHTML=`<div class="pma-msg err">${esc(d.error)}</div>`; return; }
        renderInsertForm(d.columns);
    } finally { loader(false); }
}

function renderInsertForm(cols) {
    let h = '<div class="pma-insert-grid">';
    cols.forEach(c => {
        const isAuto = (c.Extra||'').includes('auto_increment');
        const hint   = [c.Type, c.Null==='NO'?'NOT NULL':'', c.Key==='PRI'?'PRIMARY KEY':'', isAuto?'AUTO_INCREMENT':''].filter(Boolean).join(' · ');
        h += `<div class="pma-insert-row">
            <div class="col-name">
                <i class="fas fa-column" style="font-size:.6rem;opacity:.5;"></i>
                <span>${esc(c.Field)}</span>
                <span style="font-size:.65rem;color:var(--pma-muted);margin-left:4px;">${hint}</span>
            </div>
            <div class="col-val">
                <input type="text" name="insert_${esc(c.Field)}" id="ins_${esc(c.Field)}"
                    placeholder="${isAuto?'Auto':''}" ${isAuto?'disabled':''}
                    class="pma-input" style="width:100%;">
            </div>
        </div>`;
    });
    h += '</div>';
    document.getElementById('insertFormWrap').innerHTML = h;
    document.getElementById('insertBtns').style.display = 'flex';
    // Store cols for submit
    window._insertCols = cols.filter(c => !(c.Extra||'').includes('auto_increment')).map(c => c.Field);
}

async function submitInsert() {
    const row = {};
    (window._insertCols||[]).forEach(f => {
        const el = document.getElementById('ins_'+f);
        row[f] = el ? (el.value === '' ? null : el.value) : null;
    });
    loader(true);
    const url = URL_INSERT.replace('__T__', encodeURIComponent(curTable));
    try {
        const d = await apiPost(url, {row});
        if (d.success) {
            document.getElementById('insertMsg').innerHTML=`<div class="pma-msg ok"><i class="fas fa-check-circle"></i>Row inserted successfully.</div>`;
            // Clear form
            (window._insertCols||[]).forEach(f => { const el=document.getElementById('ins_'+f); if(el) el.value=''; });
        } else {
            document.getElementById('insertMsg').innerHTML=`<div class="pma-msg err"><i class="fas fa-exclamation-circle"></i>${esc(d.error||d.message||'Failed')}</div>`;
        }
    } finally { loader(false); }
}

// ── Edit row ─────────────────────────────────────────────────
function openEditRow(row) {
    editRowData = row;
    let h = '<div class="pma-insert-grid">';
    Object.entries(row).forEach(([k,v]) => {
        h += `<div class="pma-insert-row">
            <div class="col-name">${esc(k)}</div>
            <div class="col-val"><input type="text" id="edit_${esc(k)}" value="${esc(v===null?'':String(v))}" class="pma-input" style="width:100%;"></div>
        </div>`;
    });
    h += '</div>';
    document.getElementById('editModalBody').innerHTML = h;
    document.getElementById('editModal').classList.add('show');
}

function closeEditModal() { document.getElementById('editModal').classList.remove('show'); }

async function submitEdit() {
    if (!curPk) { alert('No primary key — cannot edit'); return; }
    const pkVal = editRowData[curPk];
    const row = {};
    Object.keys(editRowData).forEach(k => {
        const el = document.getElementById('edit_'+k);
        if (el) row[k] = el.value === '' ? null : el.value;
    });
    loader(true);
    const url = URL_UPDATE.replace('__T__', encodeURIComponent(curTable));
    try {
        const d = await apiPost(url, {row, pk_col: curPk, pk_val: String(pkVal)});
        if (d.success) { closeEditModal(); loadBrowse(curPage); }
        else alert('Error: ' + (d.message||'Failed'));
    } finally { loader(false); }
}

// ── Delete row ───────────────────────────────────────────────
async function deleteRow(pkVal) {
    if (!confirm('Delete this row?')) return;
    loader(true);
    const url = URL_ROW_DEL.replace('__T__', encodeURIComponent(curTable));
    try {
        const d = await apiFetch(url, 'DELETE', {pk_col: curPk, pk_val: pkVal});
        if (d.success) loadBrowse(curPage);
        else alert('Error: ' + (d.message||'Failed'));
    } finally { loader(false); }
}

// ── Drop / Truncate table ────────────────────────────────────
async function dropTable(name, hash) {
    if (!confirm(`DROP TABLE \`${name}\`?\n\nAll data will be LOST permanently!`)) return;
    loader(true);
    const url = URL_DROP.replace('__T__', encodeURIComponent(name));
    const d = await apiFetch(url, 'DELETE', {});
    loader(false);
    if (d.success) {
        document.getElementById('trow-'+hash)?.remove();
        document.querySelectorAll('.pma-tbl-item').forEach(el => { if(el.dataset.table===name) el.remove(); });
        if (curTable===name) selectDbTab('structure');
    } else alert('Error: '+(d.message||'Failed'));
}

async function emptyTable(name, hash) {
    if (!confirm(`TRUNCATE TABLE \`${name}\`?\n\nAll rows will be deleted!`)) return;
    loader(true);
    const url = URL_TRUNCATE.replace('__T__', encodeURIComponent(name));
    const d = await apiPost(url, {});
    loader(false);
    if (d.success) {
        // Update row count in table
        const cnt = document.querySelector(`#trow-${hash} td:nth-child(4)`);
        if (cnt) cnt.textContent = '0';
        if (curTable===name) loadBrowse(1);
    } else alert('Error: '+(d.message||'Failed'));
}

// ── DB Search ────────────────────────────────────────────────
async function doDbSearch() {
    const word = document.getElementById('dbSearchWord').value.trim();
    const tbl  = document.getElementById('dbSearchTable').value;
    if (!word) return;
    loader(true);
    const tables = tbl ? [tbl] : @json(array_column($tables, 'Name'));
    let html = '';
    for (const t of tables) {
        const colRes = await apiGet(URL_COLUMNS.replace('__T__', encodeURIComponent(t)));
        const cols = (colRes.columns||[]).map(c=>c.Field);
        if (!cols.length) continue;
        const where = cols.map(c=>`\`${c}\` LIKE '%${word.replace(/'/g,"\\'")}%'`).join(' OR ');
        const res = await apiPost(URL_QUERY, {sql:`SELECT * FROM \`${t}\` WHERE ${where} LIMIT 50`});
        if (res.rows?.length) {
            html += `<div style="margin-bottom:12px;"><div class="pma-struct-header" style="border-radius:6px 6px 0 0;border:1px solid var(--pma-border);padding:6px 12px;font-size:.78rem;"><strong>${esc(t)}</strong> — ${res.rows.length} row(s)</div>
            <div class="pma-data-wrap" style="border-radius:0 0 6px 6px;max-height:200px;">
            <table class="pma-data-tbl"><thead><tr>${res.columns.map(c=>`<th>${esc(c)}</th>`).join('')}</tr></thead>
            <tbody>${res.rows.map(row=>'<tr>'+res.columns.map(c=>{const v=row[c];return v===null?'<td><span class="pma-null">NULL</span></td>':`<td>${esc(String(v).slice(0,80))}</td>`;}).join('')+'</tr>').join('')}</tbody>
            </table></div></div>`;
        }
    }
    loader(false);
    document.getElementById('dbSearchResults').innerHTML = html || `<div class="pma-msg info"><i class="fas fa-info-circle"></i>No results found.</div>`;
}

async function doTblSearch() {
    const word = document.getElementById('tblSearchWord').value.trim();
    if (!word || !curTable) return;
    document.getElementById('browseSearch').value = word;
    selectTblTab('browse');
    loadBrowse(1);
}

// ── Import ───────────────────────────────────────────────────
function handleDrop(ev) { ev.preventDefault(); document.getElementById('dropZone').classList.remove('drag'); const f=ev.dataTransfer.files[0]; if(f) startImport(f); }

async function startImport(file) {
    if (!file) return;
    document.getElementById('importMsg').innerHTML='';
    document.getElementById('importProgress').style.display='block';
    document.getElementById('importBar').style.width='0%';
    document.getElementById('importLabel').textContent=`Uploading ${file.name}…`;
    const fd = new FormData(); fd.append('_token',CSRF); fd.append('file',file);
    const xhr = new XMLHttpRequest(); xhr.open('POST',URL_IMPORT); xhr.setRequestHeader('X-Requested-With','XMLHttpRequest');
    xhr.upload.onprogress = e => { if(e.lengthComputable){ const p=Math.round(e.loaded/e.total*100); document.getElementById('importBar').style.width=p+'%'; document.getElementById('importLabel').textContent=`Uploading… ${p}%`; }};
    xhr.onload = () => { document.getElementById('importProgress').style.display='none'; try { const d=JSON.parse(xhr.responseText); document.getElementById('importMsg').innerHTML=d.success?`<div class="pma-msg ok"><i class="fas fa-check-circle"></i>${esc(d.message)}</div>`:`<div class="pma-msg err"><i class="fas fa-exclamation-circle"></i>${esc(d.message)}</div>`; if(d.success) setTimeout(()=>location.reload(),1500); } catch{} };
    xhr.send(fd);
}

// ── Export ───────────────────────────────────────────────────
function exportDb(ev) { ev.preventDefault(); const t=prompt('Export type: full / structure / data','full'); if(!t) return false; window.location=URL_EXPORT+'?type='+encodeURIComponent(t||'full'); return false; }
function doExportTable(type) { window.location=URL_EXP_TBL.replace('__T__',encodeURIComponent(curTable))+'?type='+type; }

// ── Operations ───────────────────────────────────────────────
async function runOnAllTables(op) {
    const tables = @json(array_column($tables, 'Name'));
    if (!tables.length) return;
    loader(true);
    const sql = tables.map(t=>`${op} \`${t}\``).join('; ');
    const d = await apiPost(URL_QUERY, {sql: tables.map(t=>`${op} \`${t}\``).join('; ')});
    loader(false);
    // run one by one for display
    let html = '<div class="pma-data-wrap"><table class="pma-data-tbl"><thead><tr><th>Table</th><th>Op</th><th>Status</th></tr></thead><tbody>';
    for (const t of tables) {
        const r = await apiPost(URL_QUERY, {sql: `${op} \`${t}\``});
        const row = r.rows?.[0] || {};
        html += `<tr><td>${esc(t)}</td><td>${esc(row.Op||op)}</td><td style="color:var(--pma-green);">${esc(row.Msg_text||row.status||'OK')}</td></tr>`;
    }
    html += '</tbody></table></div>';
    document.getElementById('opsResult').innerHTML = html;
}

async function showDbStatus() {
    loader(true);
    const d = await apiPost(URL_QUERY, {sql: 'SHOW VARIABLES LIKE "%version%"'});
    loader(false);
    if (!d.rows) return;
    let html = '<div class="pma-data-wrap" style="max-height:300px;"><table class="pma-data-tbl"><thead><tr>'+d.columns.map(c=>`<th>${esc(c)}</th>`).join('')+'</tr></thead><tbody>'+d.rows.map(r=>'<tr>'+d.columns.map(c=>`<td>${esc(String(r[c]??''))}</td>`).join('')+'</tr>').join('')+'</tbody></table></div>';
    document.getElementById('opsResult').innerHTML = html;
}

// ── Create Table ─────────────────────────────────────────────
function openCreateTable() {
    const name = document.getElementById('newTblName').value.trim();
    const cols  = parseInt(document.getElementById('newTblCols').value)||4;
    if (!name) { alert('Enter table name'); return; }
    document.getElementById('newTblModalName').textContent = name;
    let h = '<table class="pma-tbl" style="width:100%;"><thead><tr><th>Column Name</th><th>Type</th><th>Length</th><th>Null</th><th>Default</th><th>Index</th><th>A_I</th></tr></thead><tbody>';
    for (let i=0; i<cols; i++) {
        h += `<tr>
            <td><input type="text" class="pma-input" name="col_name_${i}" placeholder="col_${i+1}" style="width:100%;"></td>
            <td><select class="pma-select" name="col_type_${i}"><option>INT</option><option>VARCHAR</option><option>TEXT</option><option>TINYTEXT</option><option>LONGTEXT</option><option>DATETIME</option><option>DATE</option><option>TIMESTAMP</option><option>FLOAT</option><option>DOUBLE</option><option>DECIMAL</option><option>BOOLEAN</option><option>TINYINT</option><option>BIGINT</option></select></td>
            <td><input type="text" class="pma-input" name="col_len_${i}" placeholder="255" style="width:60px;"></td>
            <td><input type="checkbox" name="col_null_${i}" checked></td>
            <td><input type="text" class="pma-input" name="col_def_${i}" placeholder="" style="width:70px;"></td>
            <td><select class="pma-select" name="col_idx_${i}" style="width:80px;"><option value="">—</option><option value="PRIMARY">PRIMARY</option><option value="UNIQUE">UNIQUE</option><option value="INDEX">INDEX</option></select></td>
            <td><input type="checkbox" name="col_ai_${i}"></td>
        </tr>`;
    }
    h += '</tbody></table>';
    h += '<div style="margin-top:10px;display:flex;gap:10px;flex-wrap:wrap;">';
    h += '<div class="pma-field"><label>Engine</label><select class="pma-select" id="newTblEngine"><option>InnoDB</option><option>MyISAM</option></select></div>';
    h += '<div class="pma-field"><label>Collation</label><select class="pma-select" id="newTblCollation"><option>utf8mb4_general_ci</option><option>utf8mb4_unicode_ci</option><option>utf8_general_ci</option><option>latin1_swedish_ci</option></select></div>';
    h += '</div>';
    document.getElementById('createTblBody').innerHTML = h;
    document.getElementById('createTblModal').classList.add('show');
    window._newTblName = name;
    window._newTblCols = cols;
}

async function submitCreateTable() {
    const name = window._newTblName;
    const n    = window._newTblCols;
    const engine = document.getElementById('newTblEngine').value;
    const coll   = document.getElementById('newTblCollation').value;
    let colDefs = [], pks = [];
    for (let i=0; i<n; i++) {
        const cname = document.querySelector(`[name="col_name_${i}"]`)?.value?.trim();
        if (!cname) continue;
        const ctype  = document.querySelector(`[name="col_type_${i}"]`)?.value || 'VARCHAR';
        const clen   = document.querySelector(`[name="col_len_${i}"]`)?.value?.trim();
        const cnull  = document.querySelector(`[name="col_null_${i}"]`)?.checked;
        const cdef   = document.querySelector(`[name="col_def_${i}"]`)?.value?.trim();
        const cidx   = document.querySelector(`[name="col_idx_${i}"]`)?.value;
        const cai    = document.querySelector(`[name="col_ai_${i}"]`)?.checked;
        let def = `\`${cname}\` ${ctype}`;
        if (clen && !['TEXT','LONGTEXT','TINYTEXT','DATE','DATETIME','TIMESTAMP','BOOLEAN'].includes(ctype)) def += `(${clen})`;
        if (!cnull) def += ' NOT NULL';
        if (cai) def += ' AUTO_INCREMENT';
        if (cdef) def += ` DEFAULT '${cdef}'`;
        if (cidx==='PRIMARY') pks.push(`\`${cname}\``);
        else if (cidx==='UNIQUE') colDefs.push(`UNIQUE KEY \`${cname}_uni\` (\`${cname}\`)`);
        else if (cidx==='INDEX') colDefs.push(`KEY \`${cname}_idx\` (\`${cname}\`)`);
        colDefs.unshift(def);
    }
    if (pks.length) colDefs.push(`PRIMARY KEY (${pks.join(',')})`);
    const sql = `CREATE TABLE \`${name}\` (${colDefs.join(', ')}) ENGINE=${engine} DEFAULT CHARSET=${coll.split('_')[0]};`;
    loader(true);
    try {
        const d = await apiPost(URL_CREATE_TBL, {sql});
        loader(false);
        if (d.success) {
            document.getElementById('createTblModal').classList.remove('show');
            setTimeout(()=>location.reload(), 800);
        } else { alert('Error: ' + (d.message||'Failed')); }
    } catch(e) { loader(false); alert(e.message); }
}

// ── With selected ────────────────────────────────────────────
function toggleAll(cb) { document.querySelectorAll('.row-chk').forEach(c => c.checked=cb.checked); }
function uncheckAll() { document.querySelectorAll('.row-chk').forEach(c=>c.checked=false); document.getElementById('checkAll').checked=false; }
async function doWithSelected(val) {
    if (!val) return;
    document.getElementById('withSelected').value='';
    const checked = [...document.querySelectorAll('.row-chk:checked')].map(c=>c.value);
    if (!checked.length) { alert('Select at least one table'); return; }
    if (val==='export') { alert('Export: '+checked.join(', ')+'\n\nNote: Bulk export exports each table separately.'); return; }
    if (!confirm(`${val.toUpperCase()} these tables?\n${checked.join(', ')}`)) return;
    for (const t of checked) {
        const hash = [...t].reduce((a,c)=>((a<<5)-a+c.charCodeAt(0))|0,0).toString(16).replace('-','');
        if (val==='drop') await dropTable(t, btoa(t).replace(/=/g,''));
        else if (val==='empty') await emptyTable(t, btoa(t).replace(/=/g,''));
    }
}

// ── HTTP helpers ─────────────────────────────────────────────
async function apiGet(url) {
    const r = await fetch(url, {headers:{'X-Requested-With':'XMLHttpRequest'}});
    return r.json();
}
async function apiPost(url, data) {
    const r = await fetch(url, {method:'POST',headers:{'Content-Type':'application/json','X-CSRF-TOKEN':CSRF,'X-Requested-With':'XMLHttpRequest'},body:JSON.stringify(data)});
    return r.json();
}
async function apiFetch(url, method, data) {
    const r = await fetch(url, {method,headers:{'Content-Type':'application/json','X-CSRF-TOKEN':CSRF,'X-Requested-With':'XMLHttpRequest'},body:JSON.stringify(data)});
    return r.json();
}
function esc(s) { return String(s??'').replace(/&/g,'&amp;').replace(/</g,'&lt;').replace(/>/g,'&gt;').replace(/"/g,'&quot;'); }

// ── Init ─────────────────────────────────────────────────────
document.addEventListener('DOMContentLoaded', () => {
    // Ctrl+Enter for SQL
    document.getElementById('sqlEditor')?.addEventListener('keydown', e => { if(e.ctrlKey&&e.key==='Enter') runQuery(); });
    // Connect btn loading state
    document.querySelector('form[action*="mysql/connect"]')?.addEventListener('submit', function() {
        const b=document.getElementById('connectBtn'); if(b){b.disabled=true;b.innerHTML='<i class="fas fa-circle-notch fa-spin"></i> Deploying proxy…';}
    });
});
</script>
@endsection
