@extends('layouts.dashboard')

@section('styles')
    <style>
        .picker-grid {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(280px, 1fr));
            gap: 1.5rem;
            margin-top: 2rem;
        }

        .picker-card {
            background: var(--bg-card);
            border: 1px solid var(--border);
            border-radius: 20px;
            padding: 2rem;
            text-decoration: none;
            color: inherit;
            transition: all 0.3s;
            display: flex;
            align-items: center;
            gap: 1.5rem;
        }

        .picker-card:hover {
            transform: translateY(-5px);
            border-color: var(--primary);
            box-shadow: 0 10px 30px -10px rgba(99, 102, 241, 0.3);
        }

        .picker-icon {
            width: 60px;
            height: 60px;
            background: rgba(99, 102, 241, 0.1);
            border-radius: 15px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.5rem;
            color: var(--primary);
            flex-shrink: 0;
        }

        .picker-info h3 {
            font-size: 1.1rem;
            margin-bottom: 0.3rem;
        }

        .picker-info p {
            color: var(--text-muted);
            font-size: 0.85rem;
        }
    </style>
@endsection

@section('content')
    <div class="animate-fade">
        <h2 style="margin-bottom: 0.5rem;">File Manager</h2>
        <p style="color: var(--text-muted); margin-bottom: 2rem;">Select a domain to manage its files</p>

        @if(session('error'))
            <div
                style="background: rgba(239, 68, 68, 0.1); color: #ef4444; padding: 1rem; border-radius: 12px; margin-bottom: 1.5rem; border: 1px solid rgba(239, 68, 68, 0.3);">
                {{ session('error') }}
            </div>
        @endif

        <div class="picker-grid">
            @forelse($userDomains as $ud)
                <a href="{{ route('files', ['domain' => $ud->domain, 'root' => 'domains/' . $ud->domain]) }}"
                    class="picker-card">
                    <div class="picker-icon"><i class="fas fa-globe"></i></div>
                    <div class="picker-info">
                        <h3>{{ $ud->domain }}</h3>
                        <p>~/domains/{{ $ud->domain }}</p>
                    </div>
                </a>
            @empty
                <div
                    style="grid-column: 1 / -1; text-align: center; padding: 4rem; background: var(--bg-card); border-radius: 24px; border: 1px dashed var(--border);">
                    <i class="fas fa-folder-open" style="font-size: 3rem; color: var(--text-muted); margin-bottom: 1rem;"></i>
                    <p style="color: var(--text-muted); margin-bottom: 1rem;">You haven't created any domains yet.</p>
                    <a href="{{ route('domains') }}" class="btn-primary"><i class="fas fa-plus"></i> Create Domain</a>
                </div>
            @endforelse
        </div>
    </div>
@endsection