<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Service Suspended — Hosting Expired</title>
<link href="https://fonts.googleapis.com/css2?family=Outfit:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
<style>
*{margin:0;padding:0;box-sizing:border-box;}
:root{
    --bg:#060d1a;
    --card:#0d1526;
    --border:rgba(239,68,68,.15);
    --red:#ef4444;
    --red-dim:rgba(239,68,68,.08);
    --amber:#f59e0b;
    --blue:#3b82f6;
    --muted:#64748b;
    --text:#f1f5f9;
    --sub:#94a3b8;
}
html,body{
    font-family:'Outfit',sans-serif;
    background:var(--bg);
    color:var(--text);
    min-height:100vh;
    display:flex;
    flex-direction:column;
    align-items:center;
    justify-content:center;
    overflow-x:hidden;
}

/* ── Animated background ── */
.bg-grid{
    position:fixed;inset:0;
    background-image:
        linear-gradient(rgba(239,68,68,.03) 1px,transparent 1px),
        linear-gradient(90deg,rgba(239,68,68,.03) 1px,transparent 1px);
    background-size:60px 60px;
    pointer-events:none;
}
.bg-glow{
    position:fixed;
    width:600px;height:600px;
    border-radius:50%;
    background:radial-gradient(circle,rgba(239,68,68,.06) 0%,transparent 70%);
    top:50%;left:50%;
    transform:translate(-50%,-50%);
    pointer-events:none;
    animation:breathe 4s ease-in-out infinite;
}
@keyframes breathe{
    0%,100%{transform:translate(-50%,-50%) scale(1);opacity:.6;}
    50%{transform:translate(-50%,-50%) scale(1.2);opacity:1;}
}

/* ── Main card ── */
.card{
    position:relative;z-index:1;
    background:var(--card);
    border:1px solid var(--border);
    border-radius:28px;
    padding:56px 48px;
    max-width:560px;width:calc(100% - 32px);
    text-align:center;
    box-shadow:0 40px 80px rgba(0,0,0,.6),0 0 0 1px var(--border);
}
.card::before{
    content:'';
    position:absolute;inset:-1px;
    border-radius:29px;
    background:linear-gradient(135deg,rgba(239,68,68,.1),transparent 50%,rgba(239,68,68,.05));
    pointer-events:none;
}

/* ── Lock icon ── */
.lock-wrap{
    width:88px;height:88px;
    border-radius:50%;
    background:var(--red-dim);
    border:2px solid rgba(239,68,68,.25);
    display:flex;align-items:center;justify-content:center;
    margin:0 auto 28px;
    position:relative;
    animation:lockPulse 2.5s ease-in-out infinite;
}
@keyframes lockPulse{
    0%,100%{box-shadow:0 0 0 0 rgba(239,68,68,.3);}
    50%{box-shadow:0 0 0 16px rgba(239,68,68,.0);}
}
.lock-wrap svg{width:40px;height:40px;color:var(--red);}
.lock-ring{
    position:absolute;inset:-10px;
    border-radius:50%;
    border:1px solid rgba(239,68,68,.15);
    animation:ringExpand 2.5s ease-in-out infinite;
}
.lock-ring-2{
    position:absolute;inset:-20px;
    border-radius:50%;
    border:1px solid rgba(239,68,68,.07);
    animation:ringExpand 2.5s ease-in-out infinite .4s;
}
@keyframes ringExpand{
    0%{transform:scale(.9);opacity:.8;}
    100%{transform:scale(1.05);opacity:0;}
}

/* ── Badge ── */
.status-badge{
    display:inline-flex;align-items:center;gap:6px;
    padding:5px 16px;
    background:var(--red-dim);
    border:1px solid rgba(239,68,68,.2);
    border-radius:99px;
    font-size:.72rem;font-weight:700;
    color:var(--red);
    letter-spacing:.08em;text-transform:uppercase;
    margin-bottom:20px;
}
.status-dot{
    width:6px;height:6px;border-radius:50%;
    background:var(--red);
    animation:blink 1.2s step-end infinite;
}
@keyframes blink{0%,100%{opacity:1;}50%{opacity:0;}}

/* ── Typography ── */
h1{
    font-size:1.75rem;font-weight:800;
    line-height:1.2;margin-bottom:12px;
    background:linear-gradient(135deg,#f87171,#fca5a5);
    -webkit-background-clip:text;-webkit-text-fill-color:transparent;
}
.subtitle{
    font-size:.9rem;color:var(--sub);
    line-height:1.7;margin-bottom:32px;
    max-width:400px;margin-left:auto;margin-right:auto;
}

/* ── Info boxes ── */
.info-row{
    display:flex;align-items:center;gap:12px;
    background:rgba(255,255,255,.03);
    border:1px solid rgba(255,255,255,.06);
    border-radius:12px;padding:12px 16px;
    text-align:left;margin-bottom:10px;
}
.info-row .ico{
    width:32px;height:32px;border-radius:8px;
    display:flex;align-items:center;justify-content:center;
    font-size:.85rem;flex-shrink:0;
}
.info-row .lbl{font-size:.72rem;color:var(--muted);}
.info-row .val{font-size:.84rem;font-weight:600;color:var(--text);}

/* ── Divider ── */
.divider{
    border:none;border-top:1px solid rgba(255,255,255,.06);
    margin:28px 0;
}

/* ── Contact button ── */
.btn-contact{
    display:inline-flex;align-items:center;gap:8px;
    padding:14px 32px;
    background:linear-gradient(135deg,#dc2626,#b91c1c);
    border:1px solid rgba(239,68,68,.3);
    border-radius:14px;
    color:#fff;font-size:.88rem;font-weight:700;
    text-decoration:none;cursor:pointer;
    transition:all .2s;
    box-shadow:0 8px 24px rgba(239,68,68,.25);
    margin-bottom:14px;
}
.btn-contact:hover{
    transform:translateY(-2px);
    box-shadow:0 12px 32px rgba(239,68,68,.35);
}
.btn-secondary{
    display:inline-flex;align-items:center;gap:7px;
    padding:10px 22px;
    background:rgba(255,255,255,.04);
    border:1px solid rgba(255,255,255,.08);
    border-radius:10px;
    color:var(--sub);font-size:.8rem;font-weight:600;
    text-decoration:none;cursor:pointer;
    transition:all .2s;margin:4px;
}
.btn-secondary:hover{background:rgba(255,255,255,.08);color:var(--text);}

/* ── Steps ── */
.steps{
    display:flex;flex-direction:column;gap:10px;
    margin:24px 0;text-align:left;
}
.step{
    display:flex;align-items:center;gap:12px;
    font-size:.82rem;color:var(--sub);
}
.step-num{
    width:26px;height:26px;border-radius:50%;
    background:rgba(99,102,241,.15);
    border:1px solid rgba(99,102,241,.2);
    display:flex;align-items:center;justify-content:center;
    font-size:.7rem;font-weight:700;color:#818cf8;
    flex-shrink:0;
}

/* ── Footer ── */
.footer{
    margin-top:28px;
    font-size:.72rem;color:var(--muted);
    display:flex;align-items:center;justify-content:center;gap:6px;
}
.footer a{color:var(--muted);text-decoration:none;}
.footer a:hover{color:var(--sub);}

/* ── Countdown timer ── */
#countdown-wrap{
    background:rgba(245,158,11,.06);
    border:1px solid rgba(245,158,11,.15);
    border-radius:12px;padding:14px;margin-bottom:20px;
    font-size:.8rem;color:#fbbf24;
    display:flex;align-items:center;gap:8px;justify-content:center;
}

/* ── Responsive ── */
@media(max-width:520px){
    .card{padding:36px 24px;}
    h1{font-size:1.4rem;}
    .btn-contact{padding:12px 24px;}
}
</style>
</head>
<body>
<div class="bg-grid"></div>
<div class="bg-glow"></div>

<div class="card">

    {{-- Lock icon with pulse rings --}}
    <div class="lock-wrap">
        <div class="lock-ring"></div>
        <div class="lock-ring-2"></div>
        <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.8" stroke-linecap="round" stroke-linejoin="round" style="color:#ef4444;">
            <rect x="3" y="11" width="18" height="11" rx="2" ry="2"></rect>
            <path d="M7 11V7a5 5 0 0 1 10 0v4"></path>
        </svg>
    </div>

    {{-- Status badge --}}
    <div class="status-badge">
        <span class="status-dot"></span>
        Service Suspended
    </div>

    <h1>Hosting Service Expired</h1>

    <p class="subtitle">
        The hosting subscription for this domain has expired.
        To restore your website and services, please contact your hosting provider immediately.
    </p>

    {{-- Info rows --}}
    <div class="info-row">
        <div class="ico" style="background:rgba(239,68,68,.1);">🌐</div>
        <div>
            <div class="lbl">Affected Domain</div>
            <div class="val" id="domainDisplay">{{ request()->getHost() }}</div>
        </div>
    </div>

    <div class="info-row">
        <div class="ico" style="background:rgba(245,158,11,.1);">📅</div>
        <div>
            <div class="lbl">Suspension Date</div>
            <div class="val" id="suspDate">{{ now()->format('d M Y') }}</div>
        </div>
    </div>

    <div class="info-row">
        <div class="ico" style="background:rgba(239,68,68,.1);">⚡</div>
        <div>
            <div class="lbl">Service Status</div>
            <div class="val" style="color:#ef4444;">Suspended — Awaiting Renewal</div>
        </div>
    </div>

    <hr class="divider">

    {{-- Steps to restore --}}
    <div style="text-align:left;margin-bottom:20px;">
        <div style="font-size:.75rem;font-weight:700;color:var(--muted);letter-spacing:.08em;text-transform:uppercase;margin-bottom:12px;">
            How to restore service
        </div>
        <div class="steps">
            <div class="step"><span class="step-num">1</span> Contact your hosting provider</div>
            <div class="step"><span class="step-num">2</span> Request a plan renewal or upgrade</div>
            <div class="step"><span class="step-num">3</span> Complete the payment process</div>
            <div class="step"><span class="step-num">4</span> Service will be restored within minutes</div>
        </div>
    </div>

    {{-- Action buttons --}}
    @php $adminEmail = \App\Models\AdminSetting::get('admin_email','admin@yourdomain.com'); @endphp
    <a href="mailto:{{ $adminEmail }}" class="btn-contact">
        <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><path d="M4 4h16c1.1 0 2 .9 2 2v12c0 1.1-.9 2-2 2H4c-1.1 0-2-.9-2-2V6c0-1.1.9-2 2-2z"></path><polyline points="22,6 12,12 2,6"></polyline></svg>
        Contact Hosting Provider
    </a>

    <br>

    <a href="tel:" class="btn-secondary" id="phoneBtn" style="display:none;">
        <svg width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><path d="M22 16.92v3a2 2 0 0 1-2.18 2 19.79 19.79 0 0 1-8.63-3.07A19.5 19.5 0 0 1 4.69 12 19.79 19.79 0 0 1 1.61 3.38 2 2 0 0 1 3.6 1h3a2 2 0 0 1 2 1.72c.127.96.361 1.903.7 2.81a2 2 0 0 1-.45 2.11L7.91 8.54a16 16 0 0 0 6.29 6.29l.95-.95a2 2 0 0 1 2.11-.45c.907.339 1.85.573 2.81.7A2 2 0 0 1 22 16.92z"></path></svg>
        Call Support
    </a>

    <hr class="divider">

    {{-- Powered by --}}
    <div class="footer">
        <svg width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" style="color:#4f46e5;"><rect x="2" y="3" width="20" height="14" rx="2" ry="2"></rect><line x1="8" y1="21" x2="16" y2="21"></line><line x1="12" y1="17" x2="12" y2="21"></line></svg>
        <span>Powered by <strong style="color:#818cf8;">Server Panel</strong></span>
        <span style="margin:0 6px;">·</span>
        <span>Error code: <code style="font-size:.68rem;background:rgba(255,255,255,.05);padding:1px 5px;border-radius:4px;">SUB_EXPIRED</code></span>
    </div>
</div>

<script>
// Show the actual domain
document.getElementById('domainDisplay').textContent = window.location.hostname;
</script>
</body>
</html>
