<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Subscription Expired — Server Panel</title>
<link href="https://fonts.googleapis.com/css2?family=Outfit:wght@300;400;600;700&display=swap" rel="stylesheet">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
<style>
*{margin:0;padding:0;box-sizing:border-box;font-family:'Outfit',sans-serif;}
body{background:#0f172a;color:#f8fafc;min-height:100vh;display:flex;align-items:center;justify-content:center;padding:20px;}
.card{background:#1e293b;border:1px solid rgba(255,255,255,.1);border-radius:24px;padding:48px 40px;max-width:520px;width:100%;text-align:center;position:relative;overflow:hidden;}
.card::before{content:'';position:absolute;top:-60px;left:50%;transform:translateX(-50%);width:200px;height:200px;background:radial-gradient(circle,rgba(239,68,68,.15),transparent 70%);pointer-events:none;}
.icon-wrap{width:80px;height:80px;border-radius:50%;background:rgba(239,68,68,.15);border:2px solid rgba(239,68,68,.3);display:flex;align-items:center;justify-content:center;margin:0 auto 24px;font-size:2rem;color:#ef4444;}
h1{font-size:1.6rem;font-weight:700;margin-bottom:10px;}
.subtitle{font-size:.88rem;color:#94a3b8;margin-bottom:32px;line-height:1.6;}
.info-box{background:rgba(239,68,68,.08);border:1px solid rgba(239,68,68,.2);border-radius:14px;padding:20px;margin-bottom:28px;text-align:left;}
.info-row{display:flex;align-items:center;gap:10px;font-size:.84rem;margin-bottom:8px;}
.info-row:last-child{margin-bottom:0;}
.info-row i{color:#ef4444;width:18px;flex-shrink:0;}
.info-row span{color:#94a3b8;}
.info-row strong{color:#f8fafc;}
.btn-contact{display:inline-flex;align-items:center;gap:8px;padding:13px 28px;background:linear-gradient(135deg,#6366f1,#8b5cf6);border:none;border-radius:12px;color:#fff;font-size:.88rem;font-weight:700;cursor:pointer;text-decoration:none;transition:all .2s;}
.btn-contact:hover{transform:translateY(-2px);box-shadow:0 8px 20px rgba(99,102,241,.4);}
.divider{border:none;border-top:1px solid rgba(255,255,255,.07);margin:24px 0;}
/* Support chat panel */
.support-toggle{display:inline-flex;align-items:center;gap:6px;color:#6366f1;cursor:pointer;font-size:.8rem;margin-top:16px;background:none;border:none;}
.chat-box{display:none;background:#0f172a;border-radius:14px;border:1px solid rgba(99,102,241,.2);padding:16px;margin-top:14px;text-align:left;}
.chat-box.open{display:block;}
.chat-messages{max-height:200px;overflow-y:auto;margin-bottom:10px;display:flex;flex-direction:column;gap:8px;}
.msg{padding:8px 12px;border-radius:10px;font-size:.8rem;max-width:85%;}
.msg.admin{background:rgba(99,102,241,.15);color:#a5b4fc;align-self:flex-start;}
.msg.user{background:rgba(56,189,248,.1);color:#7dd3fc;align-self:flex-end;}
.msg .time{font-size:.65rem;opacity:.5;margin-top:2px;}
.chat-input{display:flex;gap:8px;}
.chat-input input{flex:1;background:#1e293b;border:1px solid rgba(255,255,255,.1);border-radius:8px;color:#f8fafc;padding:8px 12px;font-size:.8rem;outline:none;}
.chat-input input:focus{border-color:#6366f1;}
.chat-input button{background:#6366f1;border:none;border-radius:8px;color:#fff;padding:8px 14px;cursor:pointer;font-size:.8rem;}
.logout-link{display:block;margin-top:20px;color:#64748b;font-size:.78rem;text-decoration:none;}
.logout-link:hover{color:#94a3b8;}
</style>
</head>
<body>
<div class="card">
    <div class="icon-wrap"><i class="fas fa-clock"></i></div>
    <h1>Subscription Expired</h1>
    <p class="subtitle">
        Your hosting subscription has expired. Please renew to regain access to your panel and services.
    </p>

    <div class="info-box">
        <div class="info-row"><i class="fas fa-user"></i><span>Account:</span><strong>{{ $user->name }} ({{ $user->email }})</strong></div>
        <div class="info-row"><i class="fas fa-box"></i><span>Plan:</span><strong>{{ $user->plan_name ?? 'Basic' }}</strong></div>
        <div class="info-row"><i class="fas fa-calendar-times"></i><span>Expired on:</span>
            <strong>{{ $user->subscription_expires_at ? $user->subscription_expires_at->format('d M Y') : 'N/A' }}</strong>
        </div>
        <div class="info-row"><i class="fas fa-dollar-sign"></i><span>Due amount:</span>
            <strong>${{ number_format($user->billing_amount, 2) }}</strong>
        </div>
    </div>

    <a href="mailto:admin@yourdomain.com" class="btn-contact">
        <i class="fas fa-envelope"></i> Contact Admin to Renew
    </a>

    <hr class="divider">
    <p style="font-size:.8rem;color:#64748b;">Need help? Chat with support below.</p>
    <button class="support-toggle" onclick="toggleChat()">
        <i class="fas fa-comments"></i> Open Support Chat
    </button>

    <div class="chat-box" id="chatBox">
        <div class="chat-messages" id="chatMessages">
            <p style="font-size:.75rem;color:#475569;text-align:center;">Loading messages...</p>
        </div>
        <div class="chat-input">
            <input type="text" id="chatInput" placeholder="Type your message..." onkeydown="if(event.key==='Enter')sendMsg()">
            <button onclick="sendMsg()"><i class="fas fa-paper-plane"></i></button>
        </div>
    </div>

    <form id="logoutForm" action="{{ route('logout') }}" method="POST" style="display:none;">@csrf</form>
    <a href="#" class="logout-link" onclick="document.getElementById('logoutForm').submit()">
        <i class="fas fa-sign-out-alt" style="margin-right:4px;"></i> Logout
    </a>
</div>

<script>
var chatOpen = false;
function toggleChat() {
    chatOpen = !chatOpen;
    document.getElementById('chatBox').classList.toggle('open', chatOpen);
    if (chatOpen) loadMessages();
}
function loadMessages() {
    fetch('{{ route("support.messages") }}')
        .then(r => r.json()).then(d => renderMessages(d.messages));
}
function renderMessages(msgs) {
    var box = document.getElementById('chatMessages');
    if (!msgs.length) { box.innerHTML = '<p style="font-size:.75rem;color:#475569;text-align:center;">No messages yet. Send one below!</p>'; return; }
    box.innerHTML = msgs.map(m => `<div class="msg ${m.sender}"><div>${m.message}</div><div class="time">${m.created_at}</div></div>`).join('');
    box.scrollTop = box.scrollHeight;
}
function sendMsg() {
    var input = document.getElementById('chatInput');
    var msg = input.value.trim();
    if (!msg) return;
    input.value = '';
    fetch('{{ route("support.send") }}', {
        method: 'POST',
        headers: {'Content-Type':'application/json','X-CSRF-TOKEN':'{{ csrf_token() }}'},
        body: JSON.stringify({message: msg})
    }).then(() => loadMessages());
}
setInterval(function(){ if(chatOpen) loadMessages(); }, 8000);
</script>
</body>
</html>
