@extends('layouts.admin')

@section('content')
    <style>
        :root {
            --mc-bg: #0f172a;
            --mc-card: #1e293b;
            --mc-border: #334155;
            --mc-accent: #38bdf8;
            --mc-text: #f1f5f9;
            --mc-muted: #94a3b8;
            --mc-success: #10b981;
            --mc-danger: #ef4444;
        }

        .mc-container {
            color: var(--mc-text);
            font-family: 'Inter', sans-serif;
        }

        .mc-header {
            display: flex;
            align-items: center;
            justify-content: space-between;
            margin-bottom: 24px;
        }

        .mc-header h2 {
            font-size: 1.5rem;
            font-weight: 700;
            display: flex;
            align-items: center;
            gap: 12px;
        }

        .mc-header h2 i {
            color: var(--mc-accent);
        }

        .mc-grid {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 24px;
        }

        @media (max-width: 992px) {
            .mc-grid {
                grid-template-columns: 1fr;
            }
        }

        .mc-card {
            background: var(--mc-card);
            border: 1px solid var(--mc-border);
            border-radius: 20px;
            padding: 24px;
            box-shadow: 0 10px 15px -3px rgba(0, 0, 0, 0.1);
        }

        .mc-card h3 {
            font-size: 1.1rem;
            margin-bottom: 20px;
            display: flex;
            align-items: center;
            gap: 10px;
            color: var(--mc-accent);
        }

        .mc-list {
            display: flex;
            flex-direction: column;
            gap: 10px;
            margin-bottom: 20px;
        }

        .mc-item {
            display: flex;
            align-items: center;
            gap: 12px;
            padding: 12px 16px;
            background: rgba(15, 23, 42, 0.4);
            border: 1px solid var(--mc-border);
            border-radius: 12px;
            transition: 0.2s;
        }

        .mc-item:hover {
            border-color: var(--mc-accent);
            transform: translateY(-2px);
        }

        .mc-item .mc-name {
            flex: 1;
            font-weight: 600;
            font-size: 0.95rem;
        }

        .mc-item .mc-dir {
            font-size: 0.8rem;
            color: var(--mc-muted);
            font-family: monospace;
        }

        .mc-form {
            display: flex;
            flex-direction: column;
            gap: 12px;
        }

        .mc-input-group {
            display: flex;
            gap: 8px;
        }

        .mc-input {
            flex: 1;
            background: var(--mc-bg);
            border: 1px solid var(--mc-border);
            border-radius: 10px;
            padding: 10px 14px;
            color: #fff;
            outline: none;
            transition: 0.2s;
        }

        .mc-input:focus {
            border-color: var(--mc-accent);
        }

        .mc-select {
            background: var(--mc-bg);
            border: 1px solid var(--mc-border);
            border-radius: 10px;
            padding: 10px;
            color: #fff;
            flex: 1;
        }

        .mc-btn {
            display: inline-flex;
            align-items: center;
            gap: 8px;
            padding: 10px 20px;
            border-radius: 10px;
            font-weight: 600;
            font-size: 0.9rem;
            cursor: pointer;
            border: none;
            transition: 0.2s;
        }

        .mc-btn-primary {
            background: var(--mc-accent);
            color: #000;
        }

        .mc-btn-primary:hover {
            opacity: 0.9;
            transform: scale(1.02);
        }

        .mc-btn-danger {
            background: rgba(239, 68, 68, 0.1);
            color: var(--mc-danger);
            border: 1px solid var(--mc-danger);
        }

        .mc-btn-danger:hover {
            background: var(--mc-danger);
            color: #fff;
        }

        .mc-btn-icon {
            padding: 8px;
            border-radius: 8px;
        }

        .mc-file-browser {
            margin-top: 24px;
        }

        .mc-file-grid {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(200px, 1fr));
            gap: 16px;
        }

        .mc-file-card {
            background: var(--mc-card);
            border: 1px solid var(--mc-border);
            border-radius: 16px;
            padding: 20px;
            text-align: center;
            cursor: pointer;
            transition: 0.2s;
        }

        .mc-file-card:hover {
            border-color: var(--mc-accent);
            background: rgba(56, 189, 248, 0.05);
        }

        .mc-file-card i {
            font-size: 2rem;
            color: var(--mc-accent);
            margin-bottom: 12px;
        }

        .mc-file-card p {
            font-size: 0.9rem;
            font-weight: 600;
            margin: 0;
        }

        #mc-toast {
            position: fixed;
            bottom: 24px;
            right: 24px;
            z-index: 1000;
        }

        .mc-toast-item {
            padding: 12px 24px;
            border-radius: 12px;
            font-weight: 600;
            box-shadow: 0 10px 20px rgba(0, 0, 0, 0.3);
            animation: slideIn 0.3s ease;
            margin-top: 8px;
        }

        @keyframes slideIn {
            from {
                transform: translateX(100%);
                opacity: 0;
            }

            to {
                transform: translateX(0);
                opacity: 1;
            }
        }
    </style>

    <div class="mc-container">
        <div class="mc-header">
            <h2><i class="fas fa-user-gear"></i> Manage Client: {{ $user->name }}</h2>
            <a href="{{ route('admin.index') }}" class="mc-btn"
                style="background: rgba(148, 163, 184, 0.1); color: var(--mc-muted);">
                <i class="fas fa-arrow-left"></i> Back to Dashboard
            </a>
        </div>

        <div class="mc-grid">
            {{-- Subdomain Management --}}
            <div class="mc-card">
                <h3><i class="fas fa-sitemap"></i> Subdomains</h3>
                <div class="mc-list" id="subdomainList">
                    @forelse($subdomains as $sub)
                        @php $full = $sub['domain'] . '.' . $sub['rootdomain']; @endphp
                        <div class="mc-item" id="subrow-{{ md5($full) }}">
                            <div style="flex: 1;">
                                <div class="mc-name">{{ $full }}</div>
                                <div class="mc-dir">{{ $sub['dir'] }}</div>
                            </div>
                            <div style="display: flex; gap: 6px;">
                                <a href="{{ route('admin.clients.files', ['id' => $user->id, 'domain' => $full, 'root' => $sub['dir']]) }}"
                                    class="mc-btn mc-btn-icon" style="background:rgba(56,189,248,.1);color:var(--mc-accent);"
                                    title="File Manager">
                                    <i class="fas fa-folder-open"></i>
                                </a>
                                <button class="mc-btn mc-btn-danger mc-btn-icon"
                                    onclick="deleteSub('{{ $full }}', '{{ md5($full) }}')" title="Delete">
                                    <i class="fas fa-trash"></i>
                                </button>
                            </div>
                        </div>
                    @empty
                        <div style="text-align: center; color: var(--mc-muted); padding: 20px;" id="emptyMsg">
                            <i class="fas fa-info-circle"></i> No subdomains found.
                        </div>
                    @endforelse
                </div>

                <div class="mc-form" style="border-top: 1px solid var(--mc-border); padding-top: 20px;">
                    <h4
                        style="font-size: 0.85rem; text-transform: uppercase; color: var(--mc-muted); letter-spacing: 0.05em; margin-bottom: 8px;">
                        Add New Subdomain</h4>
                    <div class="mc-input-group">
                        <input type="text" id="newSub" class="mc-input" placeholder="e.g. blog">
                        <select id="rootDomain" class="mc-select">
                            @foreach($userDomains as $d)
                                <option value="{{ $d }}">{{ $d }}</option>
                            @endforeach
                        </select>
                    </div>
                    <button class="mc-btn mc-btn-primary" onclick="createSub()">
                        <i class="fas fa-plus"></i> Create Subdomain
                    </button>
                </div>
            </div>

            {{-- File Manager Entry --}}
            <div class="mc-card">
                <h3><i class="fas fa-folder-tree"></i> File Manager</h3>
                <p style="color: var(--mc-muted); font-size: 0.9rem; margin-bottom: 24px;">Browse and manage physical files
                    for this client's domains.</p>
                <div class="mc-file-grid">
                    @foreach($userDomains as $d)
                        <a href="{{ route('admin.clients.files', ['id' => $user->id, 'domain' => $d]) }}" class="mc-file-card"
                            style="text-decoration: none; color: inherit;">
                            <i class="fas fa-folder"></i>
                            <p>{{ $d }}</p>
                        </a>
                    @endforeach
                </div>
            </div>
        </div>
    </div>

    <div id="mc-toast"></div>

    <script>
        const USER_ID = '{{ $user->id }}';
        const CSRF = '{{ csrf_token() }}';

        function toast(msg, type = 'ok') {
            const area = document.getElementById('mc-toast');
            const el = document.createElement('div');
            el.className = 'mc-toast-item';
            el.style.background = type === 'ok' ? 'var(--mc-success)' : 'var(--mc-danger)';
            el.style.color = '#fff';
            el.innerHTML = msg;
            area.appendChild(el);
            setTimeout(() => el.remove(), 3500);
        }

        async function createSub() {
            const sub = document.getElementById('newSub').value.trim();
            const root = document.getElementById('rootDomain').value;
            if (!sub) return toast('Enter subdomain', 'err');

            try {
                const r = await fetch(`/admin/clients/${USER_ID}/subdomains`, {
                    method: 'POST',
                    headers: { 'Content-Type': 'application/json', 'X-CSRF-TOKEN': CSRF },
                    body: JSON.stringify({ subdomain: sub, root_domain: root })
                });
                const d = await r.json();
                if (!d.success) return toast(d.message || 'Error', 'err');

                toast('Subdomain created!');
                location.reload();
            } catch (e) { toast(e.message, 'err'); }
        }

        async function deleteSub(sub, hash) {
            if (!confirm(`Delete ${sub}?`)) return;
            try {
                const r = await fetch(`/admin/clients/${USER_ID}/subdomains`, {
                    method: 'DELETE',
                    headers: { 'Content-Type': 'application/json', 'X-CSRF-TOKEN': CSRF },
                    body: JSON.stringify({ subdomain: sub })
                });
                const d = await r.json();
                if (!d.success) return toast(d.message || 'Error', 'err');

                document.getElementById(`subrow-${hash}`).remove();
                toast('Subdomain deleted');
            } catch (e) { toast(e.message, 'err'); }
        }
    </script>
@endsection