@extends('layouts.admin')

@section('content')
    <style>
        :root {
            --f-bg: #0f172a;
            --f-card: #1e293b;
            --f-border: #334155;
            --f-accent: #38bdf8;
            --f-text: #f1f5f9;
        }

        .f-container {
            color: var(--f-text);
            font-family: 'Inter', sans-serif;
        }

        .f-header {
            display: flex;
            align-items: center;
            gap: 20px;
            margin-bottom: 24px;
            padding: 12px 20px;
            background: var(--f-card);
            border-radius: 16px;
            border: 1px solid var(--f-border);
        }

        .f-path {
            flex: 1;
            display: flex;
            align-items: center;
            gap: 8px;
            font-size: 0.9rem;
            overflow: hidden;
        }

        .f-path a {
            color: var(--f-accent);
            text-decoration: none;
            font-weight: 600;
            white-space: nowrap;
            transition: 0.2s;
        }

        .f-path a:hover {
            text-decoration: underline;
        }

        .f-path .sep {
            color: #475569;
        }

        .f-table {
            width: 100%;
            border-collapse: collapse;
            background: var(--f-card);
            border-radius: 16px;
            overflow: hidden;
            border: 1px solid var(--f-border);
        }

        .f-table th {
            text-align: left;
            padding: 14px 20px;
            background: rgba(0, 0, 0, 0.2);
            font-size: 0.75rem;
            text-transform: uppercase;
            letter-spacing: 0.05em;
            color: #94a3b8;
        }

        .f-table td {
            padding: 10px 20px;
            border-bottom: 1px solid var(--f-border);
            font-size: 0.9rem;
            vertical-align: middle;
        }

        .f-table tr:last-child td {
            border-bottom: none;
        }

        .f-table tr:hover {
            background: rgba(56, 189, 248, 0.03);
        }

        .f-item {
            display: flex;
            align-items: center;
            gap: 12px;
        }

        .f-item i {
            font-size: 1.2rem;
            width: 20px;
            text-align: center;
        }

        .f-item .fa-folder {
            color: #fbbf24;
        }

        .f-item .fa-file {
            color: #94a3b8;
        }

        .f-item .fa-file-code {
            color: #38bdf8;
        }

        .f-btn {
            padding: 6px 12px;
            border-radius: 8px;
            font-size: 0.75rem;
            font-weight: 600;
            cursor: pointer;
            border: 1px solid var(--f-border);
            background: rgba(255, 255, 255, 0.05);
            color: #fff;
            text-decoration: none;
            transition: 0.2s;
        }

        .f-btn:hover {
            border-color: var(--f-accent);
            background: rgba(56, 189, 248, 0.1);
        }
    </style>

    <div class="f-container">
        <div style="display: flex; justify-content: space-between; align-items: flex-end; margin-bottom: 20px;">
            <div>
                <a href="{{ route('admin.clients.manage', $user->id) }}"
                    style="color: var(--f-accent); text-decoration: none; font-size: 0.85rem; display: block; margin-bottom: 5px;">
                    <i class="fas fa-arrow-left"></i> Back to Manage
                </a>
                <h2 style="font-size: 1.4rem; font-weight: 700;">File Browser: {{ $user->name }}</h2>
            </div>
            <div style="font-size: 0.85rem; color: #94a3b8;">
                Domain: <span style="color: #fff; font-weight: 600;">{{ $domain }}</span>
            </div>
        </div>

        <div class="f-header">
            <div class="f-path">
                <i class="fas fa-hdd" style="color: #64748b;"></i>
                @foreach($breadcrumbs as $index => $bc)
                    @if($index > 0) <span class="sep">/</span> @endif
                    <a
                        href="{{ route('admin.clients.files', ['id' => $user->id, 'domain' => $domain, 'dir' => $bc['path'], 'root' => $root]) }}">{{ $bc['name'] }}</a>
                @endforeach
            </div>
            <button onclick="location.reload()" class="f-btn"><i class="fas fa-sync-alt"></i></button>
        </div>

        <table class="f-table">
            <thead>
                <tr>
                    <th>Name</th>
                    <th>Size</th>
                    <th>Permissions</th>
                    <th>Modified</th>
                </tr>
            </thead>
            <tbody>
                @forelse($files as $f)
                    @php
                        $name = $f['file'] ?? $f['name'] ?? '';
                        $type = $f['type'] ?? 'file';
                        $isDir = $type === 'dir';
                        $icon = $isDir ? 'fa-folder' : 'fa-file';
                        if (!$isDir && preg_match('/\.(php|html|js|css|json)$/', $name))
                            $icon = 'fa-file-code';
                    @endphp
                    <tr>
                        <td>
                            <div class="f-item">
                                <i class="fas {{ $icon }}"></i>
                                @if($isDir)
                                    <a href="{{ route('admin.clients.files', ['id' => $user->id, 'domain' => $domain, 'dir' => $dir . '/' . $name, 'root' => $root]) }}"
                                        style="color: inherit; text-decoration: none; font-weight: 600;">{{ $name }}</a>
                                @else
                                    <span>{{ $name }}</span>
                                @endif
                            </div>
                        </td>
                        <td style="color: #94a3b8; font-size: 0.8rem;">{{ $isDir ? '-' : ($f['size'] ?? '-') }}</td>
                        <td style="color: #94a3b8; font-size: 0.8rem; font-family: monospace;">{{ $f['perms'] ?? '0644' }}</td>
                        <td style="color: #94a3b8; font-size: 0.8rem;">{{ $f['mtime'] ?? '-' }}</td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="4" style="text-align: center; padding: 40px; color: #475569;">
                            <i class="fas fa-folder-open"
                                style="font-size: 2rem; display: block; margin-bottom: 10px; opacity: 0.3;"></i>
                            Directory is empty
                        </td>
                    </tr>
                @endforelse
            </tbody>
        </table>
    </div>
@endsection