@extends('layouts.admin')

@section('content')
    <style>
        :root {
            --fp-bg: #0f172a;
            --fp-card: #1e293b;
            --fp-border: #334155;
            --fp-accent: #38bdf8;
            --fp-text: #f1f5f9;
        }

        .fp-container {
            color: var(--fp-text);
            font-family: 'Inter', sans-serif;
        }

        .fp-header {
            margin-bottom: 30px;
        }

        .fp-header h2 {
            font-size: 1.6rem;
            font-weight: 700;
            display: flex;
            align-items: center;
            gap: 12px;
        }

        .fp-header h2 i {
            color: var(--fp-accent);
        }

        .fp-grid {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(280px, 1fr));
            gap: 20px;
        }

        .fp-card {
            background: var(--fp-card);
            border: 1px solid var(--fp-border);
            border-radius: 20px;
            padding: 24px;
            text-decoration: none;
            color: inherit;
            transition: 0.2s;
            position: relative;
            overflow: hidden;
        }

        .fp-card:hover {
            border-color: var(--fp-accent);
            transform: translateY(-4px);
            box-shadow: 0 12px 24px -10px rgba(56, 189, 248, 0.3);
        }

        .fp-card i {
            font-size: 2.5rem;
            color: var(--fp-accent);
            margin-bottom: 16px;
            display: block;
        }

        .fp-card h4 {
            font-size: 1.1rem;
            font-weight: 700;
            margin: 0 0 8px 0;
        }

        .fp-card p {
            font-size: 0.85rem;
            color: #94a3b8;
            margin: 0;
        }

        .fp-card .badge {
            position: absolute;
            top: 16px;
            right: 16px;
            font-size: 0.65rem;
            padding: 4px 10px;
            border-radius: 20px;
            background: rgba(56, 189, 248, 0.1);
            color: var(--fp-accent);
            font-weight: 700;
            text-transform: uppercase;
        }
    </style>

    <div class="fp-container">
        <div class="fp-header">
            <a href="{{ route('admin.clients.manage', $user->id) }}"
                style="color: var(--fp-accent); text-decoration: none; font-size: 0.9rem; margin-bottom: 10px; display: inline-block;">
                <i class="fas fa-arrow-left"></i> Back to Manage Client
            </a>
            <h2><i class="fas fa-folder-open"></i> Select Domain to Browse Files</h2>
            <p style="color: #94a3b8; margin-top: 5px;">Managing files for client: <strong>{{ $user->name }}</strong></p>
        </div>

        <div class="fp-grid">
            @foreach($userDomains as $d)
                <a href="{{ route('admin.clients.files', ['id' => $user->id, 'domain' => $d]) }}" class="fp-card">
                    @php $isPrimary = $user->primary_domain === $d; @endphp
                    <span class="badge">{{ $isPrimary ? 'Primary' : 'Addon' }}</span>
                    <i class="fas {{ $isPrimary ? 'fa-star' : 'fa-globe' }}"></i>
                    <h4>{{ $d }}</h4>
                    <p>~/domains/{{ $d }}</p>
                </a>
            @endforeach
        </div>

        @if(empty($userDomains))
            <div
                style="text-align: center; padding: 60px; background: var(--fp-card); border-radius: 24px; border: 1px dashed var(--fp-border);">
                <i class="fas fa-ghost" style="font-size: 3rem; color: #334155; margin-bottom: 16px;"></i>
                <h3>No Domains Linked</h3>
                <p style="color: #94a3b8;">This client doesn't have any domains yet.</p>
            </div>
        @endif
    </div>
@endsection