<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::table('support_messages', function (Blueprint $table) {
            $table->string('message_type', 20)->default('text')->after('message'); // text | image | voice
            $table->string('file_path', 500)->nullable()->after('message_type');
            $table->string('agent_name', 100)->nullable()->after('file_path');
        });
    }

    public function down(): void
    {
        Schema::table('support_messages', function (Blueprint $table) {
            $table->dropColumn(['message_type', 'file_path', 'agent_name']);
        });
    }
};
