<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            // KB / MB / GB selector for disk_quota
            $table->string('disk_quota_unit', 5)->default('GB')->after('disk_quota');
            // Per-user custom renewal/billing page URL (falls back to global setting)
            $table->string('renew_url', 500)->nullable()->after('disk_quota_unit');
        });

        // Store a global renew URL in a settings-like way (we reuse the admin user row)
        // Actually we'll store it in a separate simple table
        Schema::create('admin_settings', function (Blueprint $table) {
            $table->string('key', 100)->primary();
            $table->text('value')->nullable();
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn(['disk_quota_unit', 'renew_url']);
        });
        Schema::dropIfExists('admin_settings');
    }
};
