<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->string('status', 20)->default('active')->after('role'); // active | suspended | expired
            $table->string('plan_name', 100)->default('Basic')->after('status');
            $table->decimal('billing_amount', 10, 2)->default(0)->after('plan_name');
            $table->timestamp('subscription_expires_at')->nullable()->after('billing_amount');
        });
    }

    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn(['status', 'plan_name', 'billing_amount', 'subscription_expires_at']);
        });
    }
};
