<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('user_databases', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->string('database_name');   // full name e.g. fullread_mydb
            $table->timestamps();
            $table->unique(['user_id', 'database_name']);
        });

        Schema::create('user_db_users', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->string('db_username');     // full name e.g. fullread_myuser
            $table->timestamps();
            $table->unique(['user_id', 'db_username']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('user_db_users');
        Schema::dropIfExists('user_databases');
    }
};
