<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->string('role')->default('client'); // admin or client
            $table->integer('disk_quota')->default(1024); // in MB
            $table->integer('domain_limit')->default(1);
            $table->integer('email_limit')->default(5);
            $table->string('primary_domain')->nullable(); // The domain this client is linked to
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            //
        });
    }
};
