<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class SupportMessage extends Model
{
    protected $fillable = [
        'user_id', 'sender', 'message',
        'message_type', 'file_path', 'agent_name',
        'is_read',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function fileUrl(): ?string
    {
        if (!$this->file_path) return null;
        return asset('storage/' . $this->file_path);
    }
}
