<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Notice extends Model
{
    protected $fillable = ['title', 'body', 'type', 'is_ticker', 'is_active'];

    protected function casts(): array
    {
        return [
            'is_ticker' => 'boolean',
            'is_active' => 'boolean',
        ];
    }

    public static function activeNotices()
    {
        return static::where('is_active', true)->latest()->get();
    }

    public static function tickerNotices()
    {
        return static::where('is_active', true)->where('is_ticker', true)->latest()->get();
    }
}
